/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class EnchantmentScriptContainer
extends ScriptContainer {
    public static AsciiMatcher descriptionCharsAllowed = new AsciiMatcher("abcdefghijklmnopqrstuvwxyz_");
    public static HashMap<String, EnchantmentReference> registeredEnchantmentContainers = new HashMap();
    public int minLevel;
    public int maxLevel;
    public String id;
    public String rarity;
    public String category;
    public String descriptionId;
    public String fullNameTaggable;
    public String canEnchantTaggable;
    public String isCompatibleTaggable;
    public String minCostTaggle;
    public String maxCostTaggable;
    public String damageBonusTaggable;
    public String damageProtectionTaggable;
    public boolean isTreasureOnly;
    public boolean isCurse;
    public boolean isTradable;
    public boolean isDiscoverable;
    public List<String> slots;
    public HashMap<Integer, BaseComponent[]> fullNamePerLevel = new HashMap();

    public EnchantmentScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        boolean isNew;
        this.canRunScripts = false;
        this.id = descriptionCharsAllowed.trimToMatches(CoreUtilities.toLowerCase(this.getString("id", scriptContainerName)));
        this.descriptionId = "enchantment.denizen." + this.id;
        this.minLevel = Integer.parseInt(this.getString("min_level", "1"));
        this.maxLevel = Integer.parseInt(this.getString("max_level", "1"));
        this.isTreasureOnly = CoreUtilities.toLowerCase(this.getString("treasure_only", "false")).equals("true");
        this.isCurse = CoreUtilities.toLowerCase(this.getString("is_curse", "false")).equals("true");
        this.isTradable = CoreUtilities.toLowerCase(this.getString("is_tradable", "true")).equals("true");
        this.isDiscoverable = CoreUtilities.toLowerCase(this.getString("is_discoverable", "true")).equals("true");
        this.rarity = this.getString("rarity", "COMMON").toUpperCase();
        this.category = this.getString("category", "WEAPON").toUpperCase();
        this.slots = this.getStringList("slots");
        this.fullNameTaggable = this.getString("full_name", "");
        this.canEnchantTaggable = this.getString("can_enchant", "true");
        this.isCompatibleTaggable = this.getString("is_compatible", "true");
        this.minCostTaggle = this.getString("min_cost", "1");
        this.maxCostTaggable = this.getString("max_cost", "1");
        this.damageBonusTaggable = this.getString("damage_bonus", "0.0");
        this.damageProtectionTaggable = this.getString("damage_protection", "0");
        EnchantmentReference ref = registeredEnchantmentContainers.get(this.id);
        boolean bl = isNew = ref == null;
        if (isNew) {
            ref = new EnchantmentReference();
        }
        ref.script = this;
        registeredEnchantmentContainers.put(this.id, ref);
        if (isNew) {
            NMSHandler.getItemHelper().registerFakeEnchantment(ref);
        }
    }

    public void validateThread() {
        if (!Bukkit.isPrimaryThread()) {
            try {
                throw new RuntimeException("Stack reference");
            }
            catch (RuntimeException ex) {
                Debug.echoError("Warning: enchantment access from wrong thread, errors will result");
                Debug.echoError(ex);
            }
        }
    }

    public String autoTag(String value, ContextSource src) {
        if (value == null) {
            return null;
        }
        this.validateThread();
        BukkitTagContext context = new BukkitTagContext(null, new ScriptTag(this));
        context.contextSource = src;
        return TagManager.tag(value, context);
    }

    public String autoTagForLevel(String value, int level) {
        ContextSource.SimpleMap src = new ContextSource.SimpleMap();
        src.contexts = new HashMap<String, ObjectTag>();
        src.contexts.put("level", new ElementTag(level));
        return this.autoTag(value, src);
    }

    public boolean canEnchant(ItemStack item) {
        ContextSource.SimpleMap src = new ContextSource.SimpleMap();
        src.contexts = new HashMap<String, ObjectTag>();
        src.contexts.put("item", new ItemTag(item));
        String res = this.autoTag(this.canEnchantTaggable, src);
        return CoreUtilities.toLowerCase(res).equals("true");
    }

    public boolean isCompatible(Enchantment enchantment) {
        ContextSource.SimpleMap src = new ContextSource.SimpleMap();
        src.contexts = new HashMap<String, ObjectTag>();
        src.contexts.put("enchantment_key", new ElementTag(enchantment.getKey().toString()));
        String res = this.autoTag(this.isCompatibleTaggable, src);
        return CoreUtilities.toLowerCase(res).equals("true");
    }

    public BaseComponent[] getFullName(int level) {
        BaseComponent[] result = this.fullNamePerLevel.get(level);
        if (result != null) {
            return result;
        }
        String tagged = this.autoTagForLevel(this.fullNameTaggable, level);
        result = FormattedTextHelper.parse(tagged, ChatColor.WHITE);
        this.fullNamePerLevel.put(level, result);
        return result;
    }

    public int getDamageProtection(int level, String causeName) {
        ContextSource.SimpleMap src = new ContextSource.SimpleMap();
        src.contexts = new HashMap<String, ObjectTag>();
        src.contexts.put("level", new ElementTag(level));
        src.contexts.put("cause", new ElementTag(causeName));
        return Integer.parseInt(this.autoTag(this.damageProtectionTaggable, src));
    }

    public float getDamageBonus(int level, String type) {
        ContextSource.SimpleMap src = new ContextSource.SimpleMap();
        src.contexts = new HashMap<String, ObjectTag>();
        src.contexts.put("level", new ElementTag(level));
        src.contexts.put("type", new ElementTag(type));
        return Float.parseFloat(this.autoTag(this.damageBonusTaggable, src));
    }

    public static class EnchantmentReference {
        public EnchantmentScriptContainer script;
    }
}

