/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_14;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.abstracts.Sidebar;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_14.helpers.AdvancementHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.AnimationHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.ChunkHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.CustomEntityHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.EntityHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.FishingHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.ParticleHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.PlayerHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.SoundHelperImpl;
import com.denizenscript.denizen.nms.v1_14.helpers.WorldHelperImpl;
import com.denizenscript.denizen.nms.v1_14.impl.BiomeNMSImpl;
import com.denizenscript.denizen.nms.v1_14.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_14.impl.SidebarImpl;
import com.denizenscript.denizen.nms.v1_14.impl.blocks.BlockLightImpl;
import com.denizenscript.denizen.nms.v1_14.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.HoverEvent;
import net.minecraft.server.v1_14_R1.DedicatedServer;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.IChatBaseComponent;
import net.minecraft.server.v1_14_R1.IInventory;
import net.minecraft.server.v1_14_R1.INamableTileEntity;
import net.minecraft.server.v1_14_R1.NBTBase;
import net.minecraft.server.v1_14_R1.NBTTagByteArray;
import net.minecraft.server.v1_14_R1.NBTTagString;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_14_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_14_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_14_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.persistence.PersistentDataContainer;
import org.spigotmc.AsyncCatcher;

public class Handler
extends NMSHandler {
    private final ProfileEditor profileEditor = new ProfileEditorImpl();
    private boolean wasAsyncCatcherEnabled;
    public static final Class MINECRAFT_INVENTORY;
    public static final Field INVENTORY_TITLE;
    public static final Field ENTITY_BUKKITYENTITY;

    public Handler() {
        this.advancementHelper = new AdvancementHelperImpl();
        this.animationHelper = new AnimationHelperImpl();
        this.blockHelper = new BlockHelperImpl();
        this.chunkHelper = new ChunkHelperImpl();
        this.customEntityHelper = new CustomEntityHelperImpl();
        this.entityHelper = new EntityHelperImpl();
        this.fishingHelper = new FishingHelperImpl();
        this.itemHelper = new ItemHelperImpl();
        this.soundHelper = new SoundHelperImpl();
        this.packetHelper = new PacketHelperImpl();
        this.particleHelper = new ParticleHelperImpl();
        this.playerHelper = new PlayerHelperImpl();
        this.worldHelper = new WorldHelperImpl();
    }

    @Override
    public void disableAsyncCatcher() {
        this.wasAsyncCatcherEnabled = AsyncCatcher.enabled;
        AsyncCatcher.enabled = false;
    }

    @Override
    public void undisableAsyncCatcher() {
        AsyncCatcher.enabled = this.wasAsyncCatcherEnabled;
    }

    @Override
    public boolean isCorrectMappingsCode() {
        return ((CraftMagicNumbers)CraftMagicNumbers.INSTANCE).getMappingsVersion().equals("11ae498d9cf909730659b6357e7c2afa");
    }

    @Override
    public double[] getRecentTps() {
        return ((CraftServer)Bukkit.getServer()).getServer().recentTps;
    }

    @Override
    public CompoundTag createCompoundTag(Map<String, Tag> value) {
        return new CompoundTagImpl(value);
    }

    @Override
    public Sidebar createSidebar(Player player) {
        return new SidebarImpl(player);
    }

    @Override
    public BlockLight createBlockLight(Location location, int lightLevel, long ticks) {
        return BlockLightImpl.createLight(location, lightLevel, ticks);
    }

    @Override
    public PlayerProfile fillPlayerProfile(PlayerProfile playerProfile) {
        block12: {
            try {
                if (playerProfile != null) {
                    GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
                    gameProfile.getProperties().get((Object)"textures").clear();
                    if (playerProfile.getTextureSignature() != null) {
                        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
                    } else {
                        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
                    }
                    DedicatedServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
                    GameProfile gameProfile1 = null;
                    if (gameProfile.getId() != null) {
                        gameProfile1 = minecraftServer.getUserCache().a(gameProfile.getId());
                    }
                    if (gameProfile1 == null && gameProfile.getName() != null) {
                        gameProfile1 = minecraftServer.getUserCache().getProfile(gameProfile.getName());
                    }
                    if (gameProfile1 == null) {
                        gameProfile1 = gameProfile;
                    }
                    if (playerProfile.hasTexture()) {
                        gameProfile1.getProperties().get((Object)"textures").clear();
                        if (playerProfile.getTextureSignature() != null) {
                            gameProfile1.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
                        } else {
                            gameProfile1.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
                        }
                    }
                    if (Iterables.getFirst((Iterable)gameProfile1.getProperties().get((Object)"textures"), null) == null) {
                        gameProfile1 = minecraftServer.getMinecraftSessionService().fillProfileProperties(gameProfile1, true);
                    }
                    Property property = (Property)Iterables.getFirst((Iterable)gameProfile1.getProperties().get((Object)"textures"), null);
                    return new PlayerProfile(gameProfile1.getName(), gameProfile1.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
                }
            }
            catch (Exception e) {
                if (!Debug.verbose) break block12;
                Debug.echoError(e);
            }
        }
        return null;
    }

    @Override
    public int getPort() {
        return ((CraftServer)Bukkit.getServer()).getServer().getPort();
    }

    @Override
    public String getTitle(Inventory inventory) {
        IInventory nms = ((CraftInventory)inventory).getInventory();
        if (nms instanceof INamableTileEntity) {
            return CraftChatMessage.fromComponent((IChatBaseComponent)((INamableTileEntity)nms).getDisplayName());
        }
        if (MINECRAFT_INVENTORY.isInstance(nms)) {
            try {
                return (String)INVENTORY_TITLE.get(nms);
            }
            catch (IllegalAccessException e) {
                Debug.echoError(e);
            }
        }
        return "Chest";
    }

    @Override
    public PlayerProfile getPlayerProfile(Player player) {
        GameProfile gameProfile = ((CraftPlayer)player).getProfile();
        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(gameProfile.getName(), gameProfile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
    }

    @Override
    public ProfileEditor getProfileEditor() {
        return this.profileEditor;
    }

    @Override
    public BiomeNMS getBiomeNMS(World world, String name) {
        for (Biome biome : Biome.values()) {
            if (!biome.name().equalsIgnoreCase(name)) continue;
            return new BiomeNMSImpl(world, biome);
        }
        return null;
    }

    @Override
    public String stringForHover(HoverEvent hover) {
        return FormattedTextHelper.stringify(hover.getValue(), ChatColor.WHITE);
    }

    @Override
    public ArrayList<String> containerListFlags(PersistentDataContainer container, String prefix) {
        prefix = "denizen:" + prefix;
        ArrayList<String> output = new ArrayList<String>();
        for (String key : ((CraftPersistentDataContainer)container).getRaw().keySet()) {
            if (!key.startsWith(prefix)) continue;
            output.add(key.substring(prefix.length()));
        }
        return output;
    }

    @Override
    public boolean containerHas(PersistentDataContainer container, String key) {
        return ((CraftPersistentDataContainer)container).getRaw().containsKey(key);
    }

    @Override
    public String containerGetString(PersistentDataContainer container, String key) {
        NBTBase base = (NBTBase)((CraftPersistentDataContainer)container).getRaw().get(key);
        if (base instanceof NBTTagString) {
            return base.asString();
        }
        if (base instanceof NBTTagByteArray) {
            return new String(((NBTTagByteArray)base).getBytes(), StandardCharsets.UTF_8);
        }
        return null;
    }

    static {
        ENTITY_BUKKITYENTITY = ReflectionHelper.getFields(Entity.class).get("bukkitEntity");
        Class<?> minecraftInv = null;
        Field title = null;
        try {
            for (Class<?> clzz : CraftInventoryCustom.class.getDeclaredClasses()) {
                if (!CoreUtilities.toLowerCase(clzz.getName()).contains("minecraftinventory")) continue;
                minecraftInv = clzz;
                title = clzz.getDeclaredField("title");
                title.setAccessible(true);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MINECRAFT_INVENTORY = minecraftInv;
        INVENTORY_TITLE = title;
    }
}

