/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.EnchantmentScriptContainer;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.entity.EntityDamageEvent;

public class EnchantmentTag
implements ObjectTag,
FlaggableObject {
    public Enchantment enchantment;
    private String prefix = "Enchantment";
    public static ObjectTagProcessor<EnchantmentTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static EnchantmentTag valueOf(String string) {
        return EnchantmentTag.valueOf(string, null);
    }

    @Fetchable(value="enchantment")
    public static EnchantmentTag valueOf(String string, TagContext context) {
        NamespacedKey key;
        Enchantment ench;
        if (string == null) {
            return null;
        }
        if ((string = CoreUtilities.toLowerCase(string)).startsWith("enchantment@")) {
            string = string.substring("enchantment@".length());
        }
        if ((ench = Enchantment.getByKey((NamespacedKey)(key = Utilities.parseNamespacedKey(string)))) == null) {
            ench = Enchantment.getByName((String)string.toUpperCase());
        }
        if (ench == null) {
            ench = Enchantment.getByKey((NamespacedKey)new NamespacedKey("denizen", Utilities.cleanseNamespaceID(string)));
        }
        if (ench == null && ScriptRegistry.containsScript(string, EnchantmentScriptContainer.class)) {
            ench = ScriptRegistry.getScriptContainerAs((String)string, EnchantmentScriptContainer.class).enchantment;
        }
        if (ench == null) {
            if (context == null || context.debug) {
                Debug.echoError("Unknown enchantment '" + string + "'");
            }
            return null;
        }
        return new EnchantmentTag(ench);
    }

    public static boolean matches(String arg) {
        if (CoreUtilities.toLowerCase(arg).startsWith("enchantment@")) {
            return true;
        }
        return EnchantmentTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public EnchantmentTag(Enchantment enchantment) {
        this.enchantment = enchantment;
    }

    @Override
    public String getObjectType() {
        return "Enchantment";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "enchantment@" + this.getCleanName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public EnchantmentTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getCleanName() {
        NamespacedKey key = this.enchantment.getKey();
        if (key.getNamespace().equals("minecraft") || key.getNamespace().equals("denizen")) {
            return key.getKey();
        }
        return key.toString();
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return new RedirectionFlagTracker(DenizenCore.getImplementation().getServerFlags(), "__enchantments." + this.getCleanName().replace(".", "&dot"));
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        EnchantmentTag.registerTag("name", (attribute, object) -> new ElementTag(object.getCleanName()), new String[0]);
        EnchantmentTag.registerTag("key", (attribute, object) -> new ElementTag(object.enchantment.getKey().toString()), new String[0]);
        EnchantmentTag.registerTag("full_name", (attribute, object) -> new ElementTag(object.enchantment.getKey().toString()), new String[0]);
        EnchantmentTag.registerTag("script", (attribute, object) -> {
            if (!object.enchantment.getKey().getNamespace().equals("denizen")) {
                return null;
            }
            EnchantmentScriptContainer.EnchantmentReference ref = EnchantmentScriptContainer.registeredEnchantmentContainers.get(object.enchantment.getKey().getKey());
            if (ref == null) {
                return null;
            }
            return new ScriptTag(ref.script);
        }, new String[0]);
        EnchantmentTag.registerTag("min_level", (attribute, object) -> new ElementTag(object.enchantment.getStartLevel()), new String[0]);
        EnchantmentTag.registerTag("max_level", (attribute, object) -> new ElementTag(object.enchantment.getMaxLevel()), new String[0]);
        EnchantmentTag.registerTag("treasure_only", (attribute, object) -> new ElementTag(object.enchantment.isTreasure()), new String[0]);
        EnchantmentTag.registerTag("is_tradable", (attribute, object) -> new ElementTag(NMSHandler.enchantmentHelper.isTradable(object.enchantment)), new String[0]);
        EnchantmentTag.registerTag("is_discoverable", (attribute, object) -> new ElementTag(NMSHandler.enchantmentHelper.isDiscoverable(object.enchantment)), new String[0]);
        EnchantmentTag.registerTag("is_curse", (attribute, object) -> new ElementTag(NMSHandler.enchantmentHelper.isCurse(object.enchantment)), new String[0]);
        EnchantmentTag.registerTag("category", (attribute, object) -> new ElementTag(object.enchantment.getItemTarget().name()), new String[0]);
        EnchantmentTag.registerTag("rarity", (attribute, object) -> new ElementTag(NMSHandler.enchantmentHelper.getRarity(object.enchantment)), new String[0]);
        EnchantmentTag.registerTag("can_enchant", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(object.enchantment.canEnchantItem(attribute.contextAsType(1, ItemTag.class).getItemStack()));
        }, new String[0]);
        EnchantmentTag.registerTag("is_compatible", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(!object.enchantment.conflictsWith(attribute.contextAsType((int)1, EnchantmentTag.class).enchantment));
        }, new String[0]);
        EnchantmentTag.registerTag("min_cost", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(NMSHandler.enchantmentHelper.getMinCost(object.enchantment, attribute.getIntContext(1)));
        }, new String[0]);
        EnchantmentTag.registerTag("max_cost", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(NMSHandler.enchantmentHelper.getMaxCost(object.enchantment, attribute.getIntContext(1)));
        }, new String[0]);
        EnchantmentTag.registerTag("damage_bonus", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            MapTag map = attribute.contextAsType(1, MapTag.class);
            if (map == null) {
                attribute.echoError("Invalid MapTag input to damage_bonus - not a valid map.");
                return null;
            }
            ObjectTag level = map.getObject("level");
            ObjectTag type = map.getObject("type");
            if (level == null || type == null) {
                attribute.echoError("Invalid MapTag input to damage_bonus - missing 'level' or 'type'");
                return null;
            }
            return new ElementTag(NMSHandler.enchantmentHelper.getDamageBonus(object.enchantment, new ElementTag(level.toString()).asInt(), CoreUtilities.toLowerCase(type.toString())));
        }, new String[0]);
        EnchantmentTag.registerTag("damage_protection", (attribute, object) -> {
            EntityDamageEvent.DamageCause cause;
            if (!attribute.hasContext(1)) {
                return null;
            }
            MapTag map = attribute.contextAsType(1, MapTag.class);
            if (map == null) {
                attribute.echoError("Invalid MapTag input to damage_protection - not a valid map.");
                return null;
            }
            ObjectTag level = map.getObject("level");
            ObjectTag type = map.getObject("type");
            if (level == null || type == null) {
                attribute.echoError("Invalid MapTag input to damage_protection - missing 'level' or 'type'");
                return null;
            }
            try {
                cause = EntityDamageEvent.DamageCause.valueOf((String)type.toString().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                attribute.echoError("Invalid MapTag input to damage_protection - cause '" + type.toString() + "' is not a valid DamageCause.");
                return null;
            }
            ObjectTag attacker = map.getObject("attacker");
            return new ElementTag(NMSHandler.enchantmentHelper.getDamageProtection(object.enchantment, new ElementTag(level.toString()).asInt(), cause, attacker == null ? null : attacker.asType(EntityTag.class, attribute.context).getBukkitEntity()));
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<EnchantmentTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }
}

