/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

public class InventoryScriptContainer
extends ScriptContainer {
    public boolean gui = CoreUtilities.equalsIgnoreCase(this.getString("gui", "false"), "true");

    public InventoryScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        InventoryScriptHelper.inventoryScripts.put(this.getName(), this);
    }

    /*
     * WARNING - void declaration
     */
    public InventoryTag getInventoryFrom(TagContext context) {
        InventoryTag inventory;
        block34: {
            ScriptTag thisScript;
            context = (context == null ? CoreUtilities.basicContext : context).clone();
            context.script = thisScript = new ScriptTag(this);
            context.debug = context.debug && this.shouldDebug();
            try {
                ListTag list;
                List<ScriptEntry> entries;
                String title;
                InventoryType type = InventoryType.CHEST;
                if (this.contains("inventory")) {
                    try {
                        type = InventoryType.valueOf((String)this.getString("inventory").toUpperCase());
                    }
                    catch (IllegalArgumentException ex) {
                        Debug.echoError("Invalid inventory type specified. Assuming \"CHEST\" (" + ex.getMessage() + ")");
                    }
                } else {
                    Debug.echoError("Inventory script '" + this.getName() + "' does not specify an inventory type. Assuming \"CHEST\".");
                }
                int size = 0;
                if (this.contains("size")) {
                    if (type != InventoryType.CHEST) {
                        Debug.echoError("You can only set the size of chest inventories!");
                    } else {
                        String sizeText = TagManager.tag(this.getString("size"), context);
                        if (!ArgumentHelper.matchesInteger(sizeText)) {
                            Debug.echoError("Inventory script '" + this.getName() + "' has invalid (not-a-number) size value.");
                        } else {
                            size = Integer.parseInt(sizeText);
                        }
                        if (size == 0) {
                            Debug.echoError("Inventory size can't be 0. Assuming default of inventory type...");
                        }
                        if (size % 9 != 0) {
                            size = (int)Math.ceil((double)size / 9.0) * 9;
                            Debug.echoError("Inventory size must be a multiple of 9! Rounding up to " + size + "...");
                        }
                        if (size < 0) {
                            Debug.echoError("Inventory size must be a positive number! Inverting to " + (size *= -1) + "...");
                        }
                    }
                }
                if (size == 0) {
                    size = this.contains("slots") && type == InventoryType.CHEST ? this.getStringList("slots").size() * 9 : type.getDefaultSize();
                }
                String string = title = this.contains("title") ? TagManager.tag(this.getString("title"), context) : null;
                inventory = type == InventoryType.CHEST ? new InventoryTag(size, title != null ? title : "Chest") : (title == null ? new InventoryTag(type) : new InventoryTag(type, title));
                inventory.idType = "script";
                inventory.idHolder = thisScript;
                boolean[] filledSlots = new boolean[size];
                if (this.contains("slots")) {
                    ItemStack[] finalItems = new ItemStack[size];
                    int itemsAdded = 0;
                    for (String string2 : this.getStringList("slots")) {
                        String[] itemsInLine;
                        String string3 = TagManager.tag(string2, context).trim();
                        if (string3.isEmpty()) continue;
                        if (!string3.startsWith("[") || !string3.endsWith("]")) {
                            Debug.echoError("Inventory script \"" + this.getName() + "\" has an invalid slots line: [" + string3 + "]... Ignoring it");
                            continue;
                        }
                        for (String item : itemsInLine = string3.substring(1, string3.length() - 1).split("\\[?\\]?\\s+\\[", -1)) {
                            if (this.contains("definitions." + item)) {
                                ItemTag def = ItemTag.valueOf(TagManager.tag(this.getString("definitions." + item), context), context);
                                if (def == null) {
                                    Debug.echoError("Invalid definition '" + item + "' in inventory script '" + this.getName() + "'... Ignoring it and assuming \"AIR\"");
                                    finalItems[itemsAdded] = new ItemStack(Material.AIR);
                                } else {
                                    finalItems[itemsAdded] = def.getItemStack();
                                }
                            } else if (ItemTag.matches(item)) {
                                try {
                                    finalItems[itemsAdded] = ItemTag.valueOf(item, context).getItemStack();
                                }
                                catch (Exception ex) {
                                    Debug.echoError("Inventory script \"" + this.getName() + "\" has an invalid slot item: [" + item + "]...");
                                    Debug.echoError(ex);
                                }
                            } else {
                                finalItems[itemsAdded] = new ItemStack(Material.AIR);
                                if (!item.isEmpty()) {
                                    Debug.echoError("Inventory script \"" + this.getName() + "\" has an invalid slot item: [" + item + "]... Ignoring it and assuming \"AIR\"");
                                }
                            }
                            filledSlots[itemsAdded] = !item.isEmpty();
                            ++itemsAdded;
                        }
                    }
                    inventory.setContents(finalItems);
                }
                if (!this.contains("procedural items") || (entries = this.getEntries(context.getScriptEntryData(), "procedural items")).isEmpty()) break block34;
                InstantQueue queue = new InstantQueue("INV_SCRIPT_ITEM_PROC");
                queue.addEntries(entries);
                if (this.contains("definitions")) {
                    YamlConfiguration section = this.getConfigurationSection("definitions");
                    for (StringHolder string2 : section.getKeys(false)) {
                        String definition = string2.str;
                        queue.addDefinition(definition, section.getString(definition));
                    }
                }
                queue.procedural = true;
                queue.start();
                if (queue.determinations == null || (list = ListTag.getListFor(queue.determinations.getObject(0), context)) == null) break block34;
                boolean bl = false;
                for (ItemTag item : list.filter(ItemTag.class, context, true)) {
                    void var11_19;
                    while (var11_19 < filledSlots.length && filledSlots[var11_19]) {
                        ++var11_19;
                    }
                    if (var11_19 < filledSlots.length && !filledSlots[var11_19]) {
                        inventory.setSlots((int)var11_19, item.getItemStack());
                        filledSlots[var11_19] = true;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                Debug.echoError("Woah! An exception has been called with this inventory script!");
                Debug.echoError(e);
                inventory = null;
            }
        }
        if (inventory != null) {
            InventoryTag.trackTemporaryInventory(inventory);
        }
        return inventory;
    }
}

