/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dColor;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class Conversion {
    public static List<Color> convertColors(List<dColor> colors) {
        ArrayList<Color> newList = new ArrayList<Color>();
        for (dColor color : colors) {
            newList.add(color.getColor());
        }
        return newList;
    }

    public static List<ItemStack> convertItems(List<dItem> items) {
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
        for (dItem item : items) {
            newList.add(item.getItemStack());
        }
        return newList;
    }

    public static List<Entity> convertEntities(List<dEntity> entities) {
        ArrayList<Entity> newList = new ArrayList<Entity>();
        for (dEntity entity : entities) {
            newList.add(entity.getBukkitEntity());
        }
        return newList;
    }

    public static AbstractMap.SimpleEntry<Integer, dInventory> getInventory(aH.Argument arg, ScriptEntry scriptEntry) {
        String string = arg.getValue();
        if (dInventory.matches(string)) {
            BukkitScriptEntryData data = (BukkitScriptEntryData)scriptEntry.entryData;
            if (data != null) {
                dInventory inv = dInventory.valueOf(string, data.getTagContext());
                return new AbstractMap.SimpleEntry<Integer, dInventory>(inv.getContents().length, inv);
            }
            dInventory inv = dInventory.valueOf(string, null);
            return new AbstractMap.SimpleEntry<Integer, dInventory>(inv.getContents().length, inv);
        }
        if (arg.matchesArgumentList(dItem.class)) {
            List<dItem> list = dList.valueOf(string).filter(dItem.class, scriptEntry);
            ItemStack[] items = Conversion.convertItems(list).toArray(new ItemStack[list.size()]);
            dInventory inventory = new dInventory(Math.max(54, items.length / 9 * 9 + 9));
            inventory.setContents(items);
            return new AbstractMap.SimpleEntry<Integer, dInventory>(items.length, inventory);
        }
        if (dLocation.matches(string)) {
            dInventory inv = dLocation.valueOf(string).getInventory();
            return new AbstractMap.SimpleEntry<Integer, dInventory>(inv.getContents().length, inv);
        }
        if (dEntity.matches(string)) {
            dInventory inv = dEntity.valueOf(string).getInventory();
            return new AbstractMap.SimpleEntry<Integer, dInventory>(inv.getContents().length, inv);
        }
        return null;
    }
}

