/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.maps;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.maps.MapObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class MapCursor
extends MapObject {
    protected String directionTag;
    protected String typeTag;
    protected Map<UUID, org.bukkit.map.MapCursor> cursors = new HashMap<UUID, org.bukkit.map.MapCursor>();

    public MapCursor(String xTag, String yTag, String visibilityTag, boolean debug, String directionTag, String typeTag) {
        super(xTag, yTag, visibilityTag, debug);
        this.directionTag = directionTag;
        this.typeTag = typeTag;
    }

    public byte getDirection(PlayerTag player) {
        return this.yawToDirection(Double.parseDouble(this.tag(this.directionTag, player)));
    }

    public MapCursor.Type getType(PlayerTag player) {
        return MapCursor.Type.valueOf((String)this.tag(this.typeTag, player).toUpperCase());
    }

    private byte yawToDirection(double yaw) {
        return (byte)(Math.floor(yaw / 22.5 + 0.5) % 16.0);
    }

    @Override
    public void update(PlayerTag player, UUID uuid) {
        super.update(player, uuid);
        if (this.cursors.containsKey(uuid)) {
            org.bukkit.map.MapCursor cursor = this.cursors.get(uuid);
            cursor.setX((byte)this.getX(player));
            cursor.setY((byte)this.getY(player));
            cursor.setVisible(this.isVisibleTo(player));
            cursor.setDirection(this.getDirection(player));
            cursor.setType(this.getType(player));
        }
    }

    @Override
    public Map<String, Object> getSaveData() {
        Map<String, Object> data = super.getSaveData();
        data.put("type", "CURSOR");
        data.put("direction", this.directionTag);
        data.put("cursor", this.typeTag);
        return data;
    }

    @Override
    public void render(MapView mapView, MapCanvas mapCanvas, PlayerTag player, UUID uuid) {
        try {
            org.bukkit.map.MapCursor cursor = new org.bukkit.map.MapCursor((byte)(this.getX(player) * 2), (byte)(this.getY(player) * 2), this.getDirection(player), this.getType(player).getValue(), this.isVisibleTo(player));
            mapCanvas.getCursors().addCursor(cursor);
            this.cursors.put(uuid, cursor);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }
}

