/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.type.Leaves;

public class MaterialPersistent
implements Property {
    public static final String[] handledMechs = new String[]{"persistent"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData() instanceof Leaves;
    }

    public static MaterialPersistent getFrom(ObjectTag _material) {
        if (!MaterialPersistent.describes(_material)) {
            return null;
        }
        return new MaterialPersistent((MaterialTag)_material);
    }

    private MaterialPersistent(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerTag("persistent", (attribute, material) -> new ElementTag(material.getLeaves().isPersistent()), new String[0]);
    }

    public Leaves getLeaves() {
        return (Leaves)this.material.getModernData();
    }

    public int getDistance() {
        return this.getLeaves().getDistance();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getLeaves().isPersistent());
    }

    @Override
    public String getPropertyId() {
        return "persistent";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("persistent") && mechanism.requireBoolean()) {
            this.getLeaves().setPersistent(mechanism.getValue().asBoolean());
        }
    }
}

