/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.ItemStack;

public class LootGenerateScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static LootGenerateScriptEvent instance;
    public LootGenerateEvent event;

    public LootGenerateScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("loot generates");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getLootContext().getLocation())) {
            return false;
        }
        if (path.switches.containsKey("for") && (this.event.getInventoryHolder() == null || !LootGenerateScriptEvent.runGenericSwitchCheck(path, "for", this.event.getInventoryHolder().getInventory().getType().name()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "LootGenerates";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event.getEntity() != null ? new EntityTag(this.event.getEntity()) : null);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination;
        String determinationLower;
        if (!LootGenerateScriptEvent.isDefaultDetermination(determinationObj) && determinationObj instanceof ElementTag && (determinationLower = CoreUtilities.toLowerCase(determination = determinationObj.toString())).startsWith("loot:")) {
            ListTag list = ListTag.valueOf(determination.substring("loot:".length()), this.getTagContext(path));
            ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>(list.size());
            for (ItemTag item : list.filter(ItemTag.class, this.getTagContext(path))) {
                newLoot.add(item.getItemStack());
            }
            this.event.setLoot(newLoot);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("inventory") && this.event.getInventoryHolder() != null) {
            return InventoryTag.mirrorBukkitInventory(this.event.getInventoryHolder().getInventory());
        }
        if (name.equals("entity") && this.event.getEntity() != null) {
            return new EntityTag(this.event.getEntity()).getDenizenObject();
        }
        if (name.equals("items")) {
            ListTag result = new ListTag();
            for (ItemStack item : this.event.getLoot()) {
                result.addObject(new ItemTag(item));
            }
            return result;
        }
        if (name.equals("loot_table_id")) {
            return new ElementTag(this.event.getLootTable().getKey().toString());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onLightningStrikes(LootGenerateEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

