/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.maps;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.maps.MapObject;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class DenizenMapRenderer
extends MapRenderer {
    public List<MapObject> mapObjects = new ArrayList<MapObject>();
    private List<MapRenderer> oldMapRenderers;
    public boolean autoUpdate;
    public boolean displayOriginal = true;
    private boolean active;
    public boolean hasChanged = true;

    public DenizenMapRenderer(List<MapRenderer> oldMapRenderers, boolean autoUpdate, boolean contextual) {
        super(contextual);
        this.oldMapRenderers = oldMapRenderers;
        if (oldMapRenderers.size() == 1 && oldMapRenderers.get(0) instanceof DenizenMapRenderer) {
            this.oldMapRenderers = ((DenizenMapRenderer)oldMapRenderers.get((int)0)).oldMapRenderers;
        }
        this.autoUpdate = autoUpdate;
        this.active = true;
    }

    public void addObject(MapObject object) {
        if (!this.active) {
            throw new IllegalStateException("DenizenMapRenderer is not active");
        }
        this.mapObjects.add(object);
    }

    public List<MapRenderer> getOldRenderers() {
        return this.oldMapRenderers;
    }

    public void deactivate() {
        if (!this.active) {
            throw new IllegalStateException("Already deactivated");
        }
        this.active = false;
        this.mapObjects.clear();
        this.oldMapRenderers.clear();
    }

    public boolean isActive() {
        return this.active;
    }

    public Map<String, Object> getSaveData() {
        if (!this.active) {
            throw new IllegalStateException("DenizenMapRenderer is not active");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> objects = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.mapObjects.size(); ++i) {
            Map<String, Object> objectData = this.mapObjects.get(i).getSaveData();
            objects.put(String.valueOf(i), objectData);
        }
        data.put("objects", objects);
        data.put("contextual", this.isContextual());
        data.put("auto update", this.autoUpdate);
        data.put("original", this.displayOriginal);
        return data;
    }

    public void render(MapView mapView, MapCanvas mapCanvas, Player player) {
        if (!Denizen.getInstance().isEnabled()) {
            return;
        }
        if (!this.active) {
            mapView.removeRenderer((MapRenderer)this);
            return;
        }
        if (!this.autoUpdate && !this.hasChanged) {
            return;
        }
        try {
            while (mapCanvas.getCursors().size() > 0) {
                mapCanvas.getCursors().removeCursor(mapCanvas.getCursors().getCursor(0));
            }
            if (this.displayOriginal) {
                for (MapRenderer oldR : this.oldMapRenderers) {
                    oldR.render(mapView, mapCanvas, player);
                }
            }
            UUID uuid = player.getUniqueId();
            PlayerTag p = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
            for (MapObject object : this.mapObjects) {
                if (this.autoUpdate) {
                    object.lastMap = mapView;
                    object.update(p, uuid);
                }
                if (!object.isVisibleTo(p)) continue;
                object.render(mapView, mapCanvas, p, uuid);
            }
            this.hasChanged = false;
        }
        catch (Exception e) {
            Debug.echoError(e);
            mapView.removeRenderer((MapRenderer)this);
        }
    }
}

