/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Wall;

public class MaterialHeights
implements Property {
    public static final String[] handledMechs = new String[]{"heights"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData();
        return data instanceof Wall;
    }

    public static MaterialHeights getFrom(ObjectTag _material) {
        if (!MaterialHeights.describes(_material)) {
            return null;
        }
        return new MaterialHeights((MaterialTag)_material);
    }

    private MaterialHeights(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerTag("heights", (attribute, material) -> material.getHeightsList(), new String[0]);
    }

    public Wall getWall() {
        return (Wall)this.material.getModernData();
    }

    public ListTag getHeightsList() {
        ListTag list = new ListTag(5);
        Wall wall = this.getWall();
        list.add(wall.getHeight(BlockFace.NORTH).name());
        list.add(wall.getHeight(BlockFace.EAST).name());
        list.add(wall.getHeight(BlockFace.SOUTH).name());
        list.add(wall.getHeight(BlockFace.WEST).name());
        list.add(wall.isUp() ? "TALL" : "NONE");
        return list;
    }

    @Override
    public String getPropertyString() {
        return this.getHeightsList().identify();
    }

    @Override
    public String getPropertyId() {
        return "heights";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("heights") && mechanism.requireObject(ListTag.class)) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            if (list.size() != 5) {
                mechanism.echoError("Invalid heights list, size must be 5.");
                return;
            }
            Wall wall = this.getWall();
            wall.setHeight(BlockFace.NORTH, Wall.Height.valueOf((String)list.get(0).toUpperCase()));
            wall.setHeight(BlockFace.EAST, Wall.Height.valueOf((String)list.get(1).toUpperCase()));
            wall.setHeight(BlockFace.SOUTH, Wall.Height.valueOf((String)list.get(2).toUpperCase()));
            wall.setHeight(BlockFace.WEST, Wall.Height.valueOf((String)list.get(3).toUpperCase()));
            wall.setUp(list.get(4).toUpperCase().equals("TALL"));
        }
    }
}

