/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemDisplayname
implements Property {
    public static final String[] handledTags = new String[]{"display", "has_display"};
    public static final String[] handledMechs = new String[]{"display_name"};
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem;
    }

    public static ItemDisplayname getFrom(dObject _item) {
        if (!ItemDisplayname.describes(_item)) {
            return null;
        }
        return new ItemDisplayname((dItem)_item);
    }

    private ItemDisplayname(dItem _item) {
        this.item = _item;
    }

    public boolean hasDisplayName() {
        return this.item.getItemStack().hasItemMeta() && this.item.getItemStack().getItemMeta().hasDisplayName();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("display") && this.hasDisplayName()) {
            return new Element(this.item.getItemStack().getItemMeta().getDisplayName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_display")) {
            return new Element(this.hasDisplayName()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        if (this.hasDisplayName()) {
            return EscapeTags.Escape(this.item.getItemStack().getItemMeta().getDisplayName());
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "display_name";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("display_name")) {
            ItemMeta meta = this.item.getItemStack().getItemMeta();
            meta.setDisplayName(mechanism.hasValue() ? EscapeTags.unEscape(mechanism.getValue().asString()) : null);
            this.item.getItemStack().setItemMeta(meta);
        }
    }
}

