/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.List;

public class EventCommand
extends AbstractCommand {
    public EventCommand() {
        this.setName("event");
        this.setSyntax("event [<event name>|...] (context:<name>|<object>|...)");
        this.setRequiredArguments(1, 2);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("context") && arg.matchesPrefix("context", "c")) {
                scriptEntry.addObject("context", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("events")) {
                scriptEntry.addObject("events", arg.asType(ListTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("events")) {
            throw new InvalidArgumentsException("Must specify a list of event names!");
        }
        scriptEntry.defaultObject("context", new ListTag());
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Deprecations.eventCommand.warn(scriptEntry);
        ListTag events = (ListTag)scriptEntry.getObjectTag("events");
        ListTag context = (ListTag)scriptEntry.getObjectTag("context");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), events, context);
        }
        if (context.size() % 2 == 1) {
            context.add("null");
        }
        HashMap<String, ObjectTag> context_map = new HashMap<String, ObjectTag>();
        for (int i = 0; i < context.size(); i += 2) {
            context_map.put(context.get(i), ObjectFetcher.pickObjectFor(context.get(i + 1), scriptEntry.entryData.getTagContext()));
        }
        List<String> Determination = OldEventManager.doEvents(events, scriptEntry.entryData, context_map, true);
        scriptEntry.addObject("determinations", new ListTag(Determination));
    }
}

