/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;

public class EntityInfected
implements Property {
    public static final String[] handledTags = new String[]{"is_infected"};
    public static final String[] handledMechs = new String[]{"is_infected"};
    dEntity infected;

    public static boolean describes(dObject entity) {
        if (!(entity instanceof dEntity)) {
            return false;
        }
        return ((dEntity)entity).getBukkitEntityType() == EntityType.ZOMBIE || ((dEntity)entity).getBukkitEntityType() == EntityType.VILLAGER;
    }

    public static EntityInfected getFrom(dObject entity) {
        if (!EntityInfected.describes(entity)) {
            return null;
        }
        return new EntityInfected((dEntity)entity);
    }

    private EntityInfected(dEntity item) {
        this.infected = item;
    }

    public boolean isInfected() {
        return this.infected.getBukkitEntity() instanceof Zombie && (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1) ? this.infected.getBukkitEntityType() == EntityType.ZOMBIE_VILLAGER : ((Zombie)this.infected.getBukkitEntity()).isVillager());
    }

    public void setInfected(boolean bool) {
        if (bool) {
            if (this.infected.isCitizensNPC()) {
                NPC infected_npc = this.infected.getDenizenNPC().getCitizen();
                infected_npc.setBukkitEntityType(EntityType.ZOMBIE_VILLAGER);
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1)) {
                LivingEntity entity = this.infected.getLivingEntity();
                ZombieVillager infect = (ZombieVillager)entity.getLocation().getWorld().spawnEntity((Location)this.infected.getLocation(), EntityType.ZOMBIE_VILLAGER);
                infect.setHealth(entity.getHealth());
                infect.getEquipment().setArmorContents(entity.getEquipment().getArmorContents());
                entity.remove();
                this.infected.setEntity((Entity)infect);
            } else if (this.infected.getBukkitEntity() instanceof Villager) {
                Villager villager = (Villager)this.infected.getBukkitEntity();
                Zombie infect = (Zombie)villager.getLocation().getWorld().spawnEntity((Location)this.infected.getLocation(), EntityType.ZOMBIE);
                infect.setVillager(true);
                infect.setHealth(villager.getHealth());
                infect.getEquipment().setArmorContents(villager.getEquipment().getArmorContents());
                villager.remove();
                this.infected.setEntity((Entity)infect);
            } else if (this.infected.getBukkitEntity() instanceof Zombie) {
                ((Zombie)this.infected).setVillager(true);
            }
        }
    }

    @Override
    public String getPropertyString() {
        if (this.isInfected()) {
            return "true";
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "infected";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_infected")) {
            return new Element(this.isInfected()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("is_infected") && mechanism.requireBoolean()) {
            this.setInfected(mechanism.getValue().asBoolean());
        }
    }
}

