/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.UUID;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.nms.util.PlayerProfile;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemSkullskin
implements Property {
    public static final String[] handledTags = new String[]{"skin", "has_skin"};
    public static final String[] handledMechs = new String[]{"skull_skin"};
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && ((dItem)item).getItemStack().getItemMeta() instanceof SkullMeta;
    }

    public static ItemSkullskin getFrom(dObject _item) {
        if (!ItemSkullskin.describes(_item)) {
            return null;
        }
        return new ItemSkullskin((dItem)_item);
    }

    private ItemSkullskin(dItem _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("skin")) {
            String skin = this.getPropertyString();
            if (skin != null) {
                if ((attribute = attribute.fulfill(1)).startsWith("full")) {
                    return new Element(skin).getAttribute(attribute.fulfill(1));
                }
                return new Element(CoreUtilities.split(skin, '|').get(0)).getAttribute(attribute);
            }
            dB.echoError("This skull item does not have a skin set!");
        }
        if (attribute.startsWith("has_skin")) {
            return new Element(this.getPropertyString() != null).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public boolean isCorrectDurability() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) || this.item.getItemStack().getDurability() == 3;
    }

    @Override
    public String getPropertyString() {
        PlayerProfile playerProfile;
        if (this.isCorrectDurability() && (playerProfile = NMSHandler.getInstance().getItemHelper().getSkullSkin(this.item.getItemStack())) != null) {
            String name = playerProfile.getName();
            UUID uuid = playerProfile.getUniqueId();
            return (uuid != null ? uuid : name) + (playerProfile.hasTexture() ? "|" + playerProfile.getTexture() + (uuid != null && name != null ? "|" + name : "") : "");
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "skull_skin";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("skull_skin")) {
            PlayerProfile profile;
            if (!this.isCorrectDurability()) {
                this.item.getItemStack().setDurability((short)3);
            }
            dList list = mechanism.getValue().asType(dList.class);
            String idString = (String)list.get(0);
            String texture = null;
            if (list.size() > 1) {
                texture = (String)list.get(1);
            }
            if (idString.contains("-")) {
                UUID uuid = UUID.fromString(idString);
                String name = null;
                if (list.size() > 2) {
                    name = (String)list.get(2);
                }
                profile = new PlayerProfile(name, uuid, texture);
            } else {
                profile = new PlayerProfile(idString, null, texture);
            }
            profile = NMSHandler.getInstance().fillPlayerProfile(profile);
            if (texture != null) {
                profile.setTexture(texture);
            }
            this.item.setItemStack(NMSHandler.getInstance().getItemHelper().setSkullSkin(this.item.getItemStack(), profile));
        }
    }
}

