/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.AdvancedTextImpl;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;

public class ResourcePackCommand
extends AbstractCommand {
    public ResourcePackCommand() {
        this.setName("resourcepack");
        this.setSyntax("resourcepack [url:<url>] (hash:<hash>) (forced) (prompt:<text>) (target:<player>|...)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("url") && arg.matchesPrefix("url")) {
                scriptEntry.addObject("url", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("hash") && arg.matchesPrefix("hash")) {
                scriptEntry.addObject("hash", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("forced") && arg.matches("forced")) {
                scriptEntry.addObject("forced", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("prompt") && arg.matchesPrefix("prompt")) {
                scriptEntry.addObject("prompt", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesPrefix("targets") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("targets", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("url")) {
            throw new InvalidArgumentsException("Must specify a URL!");
        }
        if (!scriptEntry.hasObject("targets")) {
            if (Utilities.entryHasPlayer(scriptEntry) && Utilities.getEntryPlayer(scriptEntry).isOnline()) {
                scriptEntry.addObject("targets", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry)));
            } else {
                throw new InvalidArgumentsException("Must specify an online player!");
            }
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List targets = (List)scriptEntry.getObjectTag("targets");
        ElementTag url = scriptEntry.getElement("url");
        ElementTag hash = scriptEntry.getElement("hash");
        ElementTag prompt = scriptEntry.getElement("prompt");
        ElementTag forced = scriptEntry.getElement("forced");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), ArgumentHelper.debugList("Targets", targets), url, hash, prompt, forced);
        }
        if (hash != null && hash.asString().length() != 40) {
            Debug.echoError("Invalid resource_pack hash. Should be 40 characters of hexadecimal data.");
            return;
        }
        for (PlayerTag player : targets) {
            if (!player.isOnline()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Player is offline, can't send resource pack to them. Skipping.");
                continue;
            }
            AdvancedTextImpl.instance.sendResourcePack(player.getPlayerEntity(), url.asString(), hash == null ? null : hash.asString(), forced != null && forced.asBoolean(), prompt == null ? null : prompt.asString());
        }
    }
}

