/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.core.ConsoleOutputScriptEvent;
import com.denizenscript.denizencore.events.core.DeltaTimeScriptEvent;
import com.denizenscript.denizencore.events.core.PreScriptReloadScriptEvent;
import com.denizenscript.denizencore.events.core.ReloadScriptsScriptEvent;
import com.denizenscript.denizencore.events.core.ScriptGeneratesErrorScriptEvent;
import com.denizenscript.denizencore.events.core.ServerGeneratesExceptionScriptEvent;
import com.denizenscript.denizencore.events.core.SystemTimeScriptEvent;
import com.denizenscript.denizencore.events.core.TickScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptEntrySet;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.WorldScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public abstract class ScriptEvent
implements ContextSource,
Cloneable {
    public static ArrayList<WorldScriptContainer> worldContainers = new ArrayList();
    public static ArrayList<ScriptEvent> events = new ArrayList();
    public static HashMap<String, ScriptEvent> eventLookup = new HashMap();
    public StatData stats = new StatData();
    public static ScriptPath tryingToBuildPath = null;
    public static ScriptEvent tryingToBuildEvent = null;
    public ArrayList<ScriptPath> eventPaths = new ArrayList();
    public boolean cancelled = false;
    private String currentEvent;
    public static final HashMap<String, MatchHelper> knownMatchers = new HashMap();

    public ScriptEvent clone() {
        try {
            return (ScriptEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Debug.echoError("Clone not supported for script events?!");
            return this;
        }
    }

    public static void registerCoreEvents() {
        ScriptEvent.registerScriptEvent(new ConsoleOutputScriptEvent());
        ScriptEvent.registerScriptEvent(new DeltaTimeScriptEvent());
        ScriptEvent.registerScriptEvent(new PreScriptReloadScriptEvent());
        ScriptEvent.registerScriptEvent(new ReloadScriptsScriptEvent());
        ScriptEvent.registerScriptEvent(new ScriptGeneratesErrorScriptEvent());
        ScriptEvent.registerScriptEvent(new ServerGeneratesExceptionScriptEvent());
        ScriptEvent.registerScriptEvent(new SystemTimeScriptEvent());
        ScriptEvent.registerScriptEvent(new TickScriptEvent());
    }

    public static void registerScriptEvent(ScriptEvent event) {
        events.add(event);
        eventLookup.put(CoreUtilities.toLowerCase(event.getName()), event);
    }

    public static void reload() {
        if (Debug.showLoading) {
            Debug.log("Reloading script events...");
        }
        for (ScriptContainer scriptContainer : worldContainers) {
            if (!CoreUtilities.equalsIgnoreCase(scriptContainer.getContents().getString("enabled", "true"), "true")) continue;
            YamlConfiguration yamlConfiguration = scriptContainer.getConfigurationSection("events");
            if (yamlConfiguration == null) {
                Debug.echoError("Missing or invalid events block for " + scriptContainer.getName());
                continue;
            }
            for (StringHolder stringHolder : yamlConfiguration.getKeys(false)) {
                if (stringHolder == null || stringHolder.str == null) {
                    Debug.echoError("Missing or invalid events block for " + scriptContainer.getName());
                    continue;
                }
                if (!CoreUtilities.contains(stringHolder.str, '@')) continue;
                Debug.echoError("Script '" + scriptContainer.getName() + "' has event '" + stringHolder.str.replace("@", "<R>@<W>") + "' which contains object notation, which is deprecated for use in world events. Please remove it.");
            }
        }
        ArrayList<ScriptPath> paths = new ArrayList<ScriptPath>(worldContainers.size() * 3);
        for (ScriptContainer scriptContainer : worldContainers) {
            YamlConfiguration config = scriptContainer.getConfigurationSection("events");
            if (config == null) continue;
            for (StringHolder evt1 : config.getKeys(false)) {
                String evt;
                boolean after = false;
                if (evt1.low.startsWith("on ")) {
                    evt = evt1.str.substring("on ".length());
                } else if (evt1.low.startsWith("after ")) {
                    evt = evt1.str.substring("after ".length());
                    after = true;
                } else {
                    Debug.echoError("Script path '" + evt1.str + "' is invalid (missing 'on' or 'after').");
                    continue;
                }
                evt = evt.replace("&dot", ".").replace("&amp", "&");
                ScriptPath path = new ScriptPath(scriptContainer, evt, evt1.str);
                path.fireAfter = after;
                if (path.set == null) {
                    Debug.echoError("Script path '" + path + "' is invalid (empty or misconfigured).");
                    continue;
                }
                paths.add(path);
            }
        }
        for (ScriptEvent scriptEvent : events) {
            try {
                scriptEvent.destroy();
                scriptEvent.eventPaths.clear();
                boolean matched = false;
                tryingToBuildEvent = scriptEvent;
                Iterator iterator = paths.iterator();
                while (iterator.hasNext()) {
                    ScriptPath path;
                    tryingToBuildPath = path = (ScriptPath)iterator.next();
                    if (!scriptEvent.couldMatch(path)) continue;
                    scriptEvent.eventPaths.add(path);
                    path.matches.add(scriptEvent);
                    if (Debug.showLoading) {
                        Debug.log("Event match, " + scriptEvent.getName() + " matched for '" + path + "'!");
                    }
                    matched = true;
                }
                if (!matched) continue;
                scriptEvent.sort();
                scriptEvent.init();
            }
            catch (Throwable ex) {
                Debug.echoError("Failed to reload event '" + scriptEvent.getName() + "':");
                Debug.echoError(ex);
            }
        }
        tryingToBuildEvent = null;
        tryingToBuildPath = null;
        for (ScriptPath scriptPath : paths) {
            if (scriptPath.matches.size() > 1) {
                Debug.log("Event " + scriptPath + " is matched to multiple ScriptEvents: " + CoreUtilities.join(", ", scriptPath.matches));
            } else if (scriptPath.matches.isEmpty()) {
                Debug.echoError("Event " + scriptPath + " is not matched to any ScriptEvents.");
                if (scriptPath.matchFailReasons != null) {
                    for (String string : scriptPath.matchFailReasons) {
                        Debug.log(string);
                    }
                }
            }
            scriptPath.matchFailReasons = null;
        }
        Debug.log("Processed " + paths.size() + " script event paths.");
    }

    public static void addPossibleCouldMatchFailReason(String reason) {
        if (tryingToBuildPath == null || tryingToBuildEvent == null) {
            return;
        }
        if (ScriptEvent.tryingToBuildPath.matchFailReasons == null) {
            ScriptEvent.tryingToBuildPath.matchFailReasons = new ArrayList<String>();
        }
        ScriptEvent.tryingToBuildPath.matchFailReasons.add("Almost matched: " + tryingToBuildEvent.getName() + ", but failed because: " + reason);
    }

    public static boolean matchesScript(ScriptEvent sEvent, ScriptPath path) {
        if (path.switch_cancelled != null ? path.switch_cancelled != sEvent.cancelled : (path.switch_ignoreCancelled != null ? path.switch_ignoreCancelled == false && sEvent.cancelled : sEvent.cancelled)) {
            return false;
        }
        return sEvent.matches(path);
    }

    public void sort() {
        try {
            for (ScriptPath path : this.eventPaths) {
                String gotten = path.switches.get("priority");
                path.priority = gotten == null ? 0 : Integer.parseInt(gotten);
            }
        }
        catch (NumberFormatException ex) {
            Debug.echoError("Failed to sort events: not-a-number priority value! " + ex.getMessage());
        }
        this.eventPaths.sort((scriptPath, t1) -> {
            int rel = scriptPath.priority - t1.priority;
            return Integer.compare(rel, 0);
        });
    }

    public void init() {
    }

    public void destroy() {
    }

    public void cancellationChanged() {
    }

    @Deprecated
    public static boolean isDefaultDetermination(ObjectTag determination) {
        Debug.echoError("VERSION MISMATCH, UPDATE ALL DENIZEN-RELATED SUBPROJECTS.");
        return false;
    }

    public boolean applyDetermination(ScriptPath path, ObjectTag determination) {
        Debug.echoError("Unknown determination '" + determination + "'");
        return false;
    }

    public boolean handleBaseDetermination(ScriptPath path, ObjectTag determination) {
        String text;
        if (determination instanceof ElementTag && (text = determination.toString()).length() <= "cancelled:false".length()) {
            String low;
            switch (low = CoreUtilities.toLowerCase(text)) {
                case "cancelled:true": 
                case "cancelled": {
                    Debug.echoDebug((Debuggable)path.container, "Event cancelled!");
                    this.cancelled = true;
                    this.cancellationChanged();
                    return true;
                }
                case "cancelled:false": {
                    Debug.echoDebug((Debuggable)path.container, "Event uncancelled!");
                    this.cancelled = false;
                    this.cancellationChanged();
                    return true;
                }
            }
        }
        return this.applyDetermination(path, determination);
    }

    public ScriptEntryData getScriptEntryData() {
        return DenizenCore.getImplementation().getEmptyScriptEntryData();
    }

    public boolean couldMatch(ScriptPath path) {
        throw new UnsupportedOperationException("CouldMatch not implemented for event '" + this.getName() + "'! Report this error to the Denizen developers!");
    }

    public boolean matches(ScriptPath path) {
        String flagSwitch = path.switches.get("server_flagged");
        if (flagSwitch != null) {
            for (String flag : CoreUtilities.split(flagSwitch, '|')) {
                if (DenizenCore.getImplementation().getServerFlags().hasFlag(flag)) continue;
                return false;
            }
        }
        return true;
    }

    public abstract String getName();

    public ScriptEvent fire() {
        ScriptEvent copy = this.clone();
        ++this.stats.fires;
        for (ScriptPath path : this.eventPaths) {
            try {
                if (!ScriptEvent.matchesScript(copy, path)) continue;
                if (path.fireAfter) {
                    ScriptPath finalPath = path;
                    DenizenCore.schedule(new OneTimeSchedulable(() -> copy.run(finalPath), 0.01f));
                    continue;
                }
                copy.run(path);
            }
            catch (Exception e) {
                Debug.echoError("Matching script " + path.container.getName() + " event path:" + path.event + ":::");
                Debug.echoError(e);
            }
        }
        return copy;
    }

    public void run(ScriptPath path) {
        try {
            ++this.stats.scriptFires;
            if (path.container.shouldDebug()) {
                Debug.echoDebug((Debuggable)path.container, "<Y>Running script event '<A>" + this.getName() + "<Y>', event='<A>" + (path.fireAfter ? "after " : "on ") + path.event + "<Y>' for script '<A>" + path.container.getName() + "<Y>'");
            }
            if (path.set == null) {
                return;
            }
            List<ScriptEntry> entries = ScriptContainer.cleanDup(this.getScriptEntryData(), path.set);
            ScriptQueue queue = new InstantQueue(path.container.getName()).addEntries(entries);
            this.currentEvent = path.event;
            queue.setContextSource(this);
            if (!path.fireAfter) {
                queue.determinationTarget = o -> this.handleBaseDetermination(path, o);
            }
            queue.start();
            this.stats.nanoTimes += System.nanoTime() - queue.startTime;
        }
        catch (Exception e) {
            Debug.echoError("Handling script " + path.container.getName() + " path:" + path.event + ":::");
            Debug.echoError(e);
        }
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "cancelled": {
                return new ElementTag(this.cancelled);
            }
            case "event_header": {
                return new ElementTag(this.currentEvent);
            }
            case "event_name": {
                return new ElementTag(this.getName());
            }
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public static boolean isAdvancedMatchable(String input) {
        return input.startsWith("regex:") || CoreUtilities.contains(input, '|') || CoreUtilities.contains(input, '*') || input.startsWith("!");
    }

    public static MatchHelper createMatcher(String input) {
        MatchHelper result = knownMatchers.get(input);
        if (result != null) {
            return result;
        }
        if (input.startsWith("!")) {
            result = new InverseMatchHelper(ScriptEvent.createMatcher(input.substring(1)));
        } else if (input.startsWith("regex:")) {
            result = new RegexMatchHelper(input.substring("regex:".length()));
        } else if (CoreUtilities.contains(input, '|')) {
            String toSplit = input;
            if (toSplit.startsWith("li@")) {
                toSplit = toSplit.substring("li@".length());
            }
            toSplit = CoreUtilities.replace(toSplit, "el@", "");
            List<String> split = CoreUtilities.split(toSplit, '|');
            MatchHelper[] matchers = new MatchHelper[split.size()];
            for (int i = 0; i < split.size(); ++i) {
                matchers[i] = ScriptEvent.createMatcher(split.get(i));
            }
            result = new MultipleMatchesHelper(matchers);
        } else {
            int asterisk = input.indexOf(42);
            result = asterisk != -1 ? (input.length() == 1 ? new AlwaysMatchHelper() : (asterisk == 0 && input.indexOf(42, 1) == -1 ? new PrefixAsteriskMatchHelper(input.substring(1)) : (asterisk == input.length() - 1 ? new PostfixAsteriskMatchHelper(input.substring(0, input.length() - 1)) : new MultipleAsteriskMatchHelper(CoreUtilities.split(CoreUtilities.toLowerCase(input), '*').toArray(new String[0]))))) : new ExactMatchHelper(input);
        }
        knownMatchers.put(input, result);
        return result;
    }

    public static boolean runGenericCheck(String matchableValue, String trueValue) {
        if (matchableValue == null) {
            return false;
        }
        trueValue = CoreUtilities.toLowerCase(trueValue);
        MatchHelper matcher = ScriptEvent.createMatcher(matchableValue);
        return matcher.doesMatch(trueValue);
    }

    public static boolean runGenericSwitchCheck(ScriptPath path, String switchName, String value) {
        String with = path.switches.get(switchName);
        if (with == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        value = CoreUtilities.toLowerCase(value);
        MatchHelper matcher = ScriptEvent.createMatcher(with);
        return matcher.doesMatch(value);
    }

    public static class InverseMatchHelper
    extends MatchHelper {
        public MatchHelper matcher;

        public InverseMatchHelper(MatchHelper matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean doesMatch(String input) {
            return !this.matcher.doesMatch(input);
        }
    }

    public static class MultipleMatchesHelper
    extends MatchHelper {
        public MatchHelper[] matches;

        public MultipleMatchesHelper(MatchHelper[] matches) {
            this.matches = matches;
        }

        @Override
        public boolean doesMatch(String input) {
            for (MatchHelper match : this.matches) {
                if (!match.doesMatch(input)) continue;
                return true;
            }
            return false;
        }
    }

    public static class RegexMatchHelper
    extends MatchHelper {
        public Pattern regex;

        public RegexMatchHelper(String regex) {
            this.regex = Pattern.compile(regex, 2);
        }

        @Override
        public boolean doesMatch(String input) {
            return this.regex.matcher(input).matches();
        }
    }

    public static class MultipleAsteriskMatchHelper
    extends MatchHelper {
        public String[] texts;

        public MultipleAsteriskMatchHelper(String[] texts) {
            this.texts = texts;
        }

        @Override
        public boolean doesMatch(String input) {
            int index = 0;
            if (!(input = CoreUtilities.toLowerCase(input)).startsWith(this.texts[0]) || !input.endsWith(this.texts[this.texts.length - 1])) {
                return false;
            }
            for (String text : this.texts) {
                if (text.isEmpty()) continue;
                if ((index = input.indexOf(text, index)) == -1) {
                    return false;
                }
                index += text.length();
            }
            return true;
        }
    }

    public static class PostfixAsteriskMatchHelper
    extends MatchHelper {
        public String text;

        public PostfixAsteriskMatchHelper(String text) {
            this.text = CoreUtilities.toLowerCase(text);
        }

        @Override
        public boolean doesMatch(String input) {
            return CoreUtilities.toLowerCase(input).startsWith(this.text);
        }
    }

    public static class PrefixAsteriskMatchHelper
    extends MatchHelper {
        public String text;

        public PrefixAsteriskMatchHelper(String text) {
            this.text = CoreUtilities.toLowerCase(text);
        }

        @Override
        public boolean doesMatch(String input) {
            return CoreUtilities.toLowerCase(input).endsWith(this.text);
        }
    }

    public static class ExactMatchHelper
    extends MatchHelper {
        public String text;

        public ExactMatchHelper(String text) {
            this.text = CoreUtilities.toLowerCase(text);
        }

        @Override
        public boolean doesMatch(String input) {
            return CoreUtilities.equalsIgnoreCase(this.text, input);
        }
    }

    public static class AlwaysMatchHelper
    extends MatchHelper {
        @Override
        public boolean doesMatch(String input) {
            return true;
        }
    }

    public static abstract class MatchHelper {
        public abstract boolean doesMatch(String var1);
    }

    public static class ScriptPath {
        public ScriptContainer container;
        public String event;
        public String eventLower;
        public int priority = 0;
        public ScriptEntrySet set;
        public Boolean switch_cancelled;
        public Boolean switch_ignoreCancelled;
        public HashMap<String, String> switches = new HashMap();
        public String[] eventArgs;
        public String[] eventArgsLower;
        public String[] rawEventArgs;
        public List<ScriptEvent> matches = new ArrayList<ScriptEvent>();
        public TagContext context;
        public boolean fireAfter = false;
        public List<String> matchFailReasons = null;
        public static HashSet<String> notSwitches = new HashSet<String>(Arrays.asList("regex", "item_flagged", "world_flagged", "area_flagged", "inventory_flagged", "player_flagged", "npc_flagged", "entity_flagged", "vanilla_tagged", "raw_exact", "item_enchanted"));

        public String rawEventArgAt(int index) {
            return index < this.rawEventArgs.length ? this.rawEventArgs[index] : "";
        }

        public String eventArgAt(int index) {
            return index < this.eventArgs.length ? this.eventArgs[index] : "";
        }

        public String eventArgLowerAt(int index) {
            return index < this.eventArgsLower.length ? this.eventArgsLower[index] : "";
        }

        public boolean checkSwitch(String key, String value) {
            String pathValue = this.switches.get(key);
            if (pathValue == null) {
                return true;
            }
            return CoreUtilities.equalsIgnoreCase(pathValue, value);
        }

        public ScriptPath(ScriptContainer container, String event, String rawEventPath) {
            this.event = event;
            this.rawEventArgs = CoreUtilities.split(event, ' ').toArray(new String[0]);
            this.container = container;
            this.context = DenizenCore.getImplementation().getTagContext(container);
            ArrayList<String> eventLabel = new ArrayList<String>();
            for (String possible : CoreUtilities.split(event, ' ').toArray(new String[0])) {
                List<String> split = CoreUtilities.split(possible, ':', 2);
                if (split.size() > 1 && !ArgumentHelper.matchesInteger(split.get(0)) && !notSwitches.contains(CoreUtilities.toLowerCase(split.get(0)))) {
                    this.switches.put(CoreUtilities.toLowerCase(split.get(0)), split.get(1));
                    continue;
                }
                eventLabel.add(possible);
            }
            this.eventLower = CoreUtilities.toLowerCase(String.join((CharSequence)" ", eventLabel));
            this.eventArgs = eventLabel.toArray(new String[0]);
            this.eventArgsLower = CoreUtilities.split(this.eventLower, ' ').toArray(new String[0]);
            this.switch_cancelled = this.switches.containsKey("cancelled") ? Boolean.valueOf(CoreUtilities.equalsIgnoreCase(this.switches.get("cancelled"), "true")) : null;
            this.switch_ignoreCancelled = this.switches.containsKey("ignorecancelled") ? Boolean.valueOf(CoreUtilities.equalsIgnoreCase(this.switches.get("ignorecancelled"), "true")) : null;
            this.set = container.getSetFor("events." + rawEventPath);
            if (this.set == null || this.set.entries == null) {
                Debug.echoError("Invalid script (formatting error?) in container '" + container.getName() + " at event '" + rawEventPath + "'.");
            }
        }

        public String toString() {
            return this.container.getName() + ".events.on " + this.event;
        }
    }

    public static class StatData {
        public long fires = 0L;
        public long scriptFires = 0L;
        public long nanoTimes = 0L;
    }
}

