/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemPotion
implements Property {
    public static final String[] handledTags = new String[]{"potion_base_type", "potion_base", "has_potion_effect", "potion_effect", "potion_effects"};
    public static final String[] handledMechs = new String[]{"potion_effects"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && (((ItemTag)item).getBukkitMaterial() == Material.POTION || ((ItemTag)item).getBukkitMaterial() == Material.SPLASH_POTION || ((ItemTag)item).getBukkitMaterial() == Material.LINGERING_POTION || ((ItemTag)item).getBukkitMaterial() == Material.TIPPED_ARROW);
    }

    public static ItemPotion getFrom(ObjectTag _item) {
        if (!ItemPotion.describes(_item)) {
            return null;
        }
        return new ItemPotion((ItemTag)_item);
    }

    private ItemPotion(ItemTag item) {
        this.item = item;
    }

    public static String stringifyEffect(PotionEffect effect) {
        StringBuilder sb = new StringBuilder();
        sb.append(effect.getType().getName()).append(",").append(effect.getAmplifier()).append(",").append(effect.getDuration()).append(",").append(effect.isAmbient()).append(",").append(effect.hasParticles()).append(",").append(effect.hasIcon());
        return sb.toString();
    }

    public static PotionEffect parseEffect(String str, TagContext context) {
        ElementTag check;
        PotionEffectType type;
        String[] d2 = str.split(",");
        try {
            type = PotionEffectType.getByName((String)d2[0].toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            if (context.showErrors()) {
                Debug.echoError("Invalid potion effect type '" + d2[0] + "'");
            }
            return null;
        }
        if (d2.length < 3) {
            return null;
        }
        int duration = new ElementTag(d2[2]).asInt();
        int amplifier = new ElementTag(d2[1]).asInt();
        boolean ambient = true;
        boolean particles = true;
        if (d2.length > 3) {
            ambient = new ElementTag(d2[3]).asBoolean();
            particles = new ElementTag(d2[4]).asBoolean();
        }
        boolean icon = false;
        if (d2.length > 5 && (check = new ElementTag(d2[5])).isBoolean()) {
            icon = check.asBoolean();
        }
        return NMSHandler.getItemHelper().getPotionEffect(type, duration, amplifier, ambient, particles, icon);
    }

    @Override
    public String getPropertyString() {
        if (!(this.item.getItemMeta() instanceof PotionMeta)) {
            return null;
        }
        PotionMeta meta = (PotionMeta)this.item.getItemMeta();
        ListTag effects = new ListTag();
        effects.add(meta.getBasePotionData().getType() + "," + meta.getBasePotionData().isUpgraded() + "," + meta.getBasePotionData().isExtended() + (meta.hasColor() ? "," + new ColorTag(meta.getColor()).identify().replace(",", "&comma") : ""));
        for (PotionEffect pot : meta.getCustomEffects()) {
            effects.add(ItemPotion.stringifyEffect(pot));
        }
        return effects.identify();
    }

    @Override
    public String getPropertyId() {
        return "potion_effects";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        boolean has;
        if (attribute == null) {
            return null;
        }
        boolean bl = has = this.item.getItemMeta() instanceof PotionMeta && ((PotionMeta)this.item.getItemMeta()).hasCustomEffects();
        if (attribute.startsWith("potion_base_type") && this.item.getItemMeta() instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)this.item.getItemMeta();
            return new ElementTag(meta.getBasePotionData().getType().name()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("potion_base") && this.item.getItemMeta() instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)this.item.getItemMeta();
            return new ElementTag(meta.getBasePotionData().getType().name() + "," + (meta.getBasePotionData().isUpgraded() ? 2 : 1) + "," + meta.getBasePotionData().isExtended() + "," + (this.item.getBukkitMaterial() == Material.SPLASH_POTION) + (meta.hasColor() ? "," + new ColorTag(meta.getColor()).identify() : "")).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("potion_effects") && this.item.getItemMeta() instanceof PotionMeta) {
            ListTag result = new ListTag();
            PotionMeta meta = (PotionMeta)this.item.getItemMeta();
            for (PotionEffect pot : meta.getCustomEffects()) {
                result.add(ItemPotion.stringifyEffect(pot));
            }
            return result.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_potion_effect")) {
            return new ElementTag(has).getObjectAttribute(attribute.fulfill(1));
        }
        if (has && attribute.startsWith("potion_effect")) {
            int potN;
            PotionMeta meta = (PotionMeta)this.item.getItemMeta();
            int n = potN = attribute.hasContext(1) ? attribute.getIntContext(1) - 1 : 0;
            if (potN < 0 || potN > meta.getCustomEffects().size()) {
                return null;
            }
            if ((attribute = attribute.fulfill(1)).startsWith("is_splash")) {
                return new ElementTag(this.item.getBukkitMaterial() == Material.SPLASH_POTION).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_extended")) {
                return new ElementTag(meta.getBasePotionData().isExtended()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("level")) {
                return new ElementTag(meta.getBasePotionData().isUpgraded() ? 2 : 1).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_ambient")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).isAmbient()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("icon")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).hasIcon()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("has_particles")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).hasParticles()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("duration")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).getDuration()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("amplifier")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).getAmplifier()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("type")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).getType().getName()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("data")) {
                return new ElementTag(0).getObjectAttribute(attribute.fulfill(1));
            }
            return new ElementTag(meta.getBasePotionData().getType().name() + "," + (meta.getBasePotionData().isUpgraded() ? 2 : 1) + "," + meta.getBasePotionData().isExtended() + "," + (this.item.getBukkitMaterial() == Material.SPLASH_POTION)).getObjectAttribute(attribute);
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("potion_effects")) {
            PotionType type;
            ListTag data = mechanism.valueAsType(ListTag.class);
            String[] d1 = data.get(0).split(",");
            PotionMeta meta = (PotionMeta)this.item.getItemMeta();
            try {
                type = PotionType.valueOf((String)d1[0].toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                mechanism.echoError("Invalid potion type name '" + d1[0] + "'");
                return;
            }
            boolean upgraded = CoreUtilities.equalsIgnoreCase(d1[1], "true");
            boolean extended = CoreUtilities.equalsIgnoreCase(d1[2], "true");
            if (upgraded && !type.isUpgradeable()) {
                mechanism.echoError("Cannot upgrade potion of type '" + type.name() + "'");
                upgraded = false;
            }
            if (extended && !type.isExtendable()) {
                mechanism.echoError("Cannot extend potion of type '" + type.name() + "'");
                upgraded = false;
            }
            if (upgraded && extended) {
                mechanism.echoError("Cannot both upgrade and extend a potion");
                extended = false;
            }
            meta.setBasePotionData(new PotionData(type, extended, upgraded));
            if (d1.length > 3) {
                ColorTag color = ColorTag.valueOf(d1[3].replace("&comma", ","), mechanism.context);
                if (color == null) {
                    mechanism.echoError("Invalid ColorTag input '" + d1[3] + "'");
                }
                meta.setColor(color.getColor());
            }
            meta.clearCustomEffects();
            for (int i = 1; i < data.size(); ++i) {
                PotionEffect effect = ItemPotion.parseEffect(data.get(i), mechanism.context);
                if (effect == null) {
                    mechanism.echoError("Invalid potion effect '" + data.get(i) + "'");
                    continue;
                }
                meta.addCustomEffect(effect, false);
            }
            this.item.setItemMeta((ItemMeta)meta);
        }
    }
}

