/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.inventory.InventoryContents;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.AbstractMap;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemInventory
implements Property {
    public static final String[] handledTags = new String[]{"inventory", "inventory_contents"};
    public static final String[] handledMechs = new String[]{"inventory", "inventory_contents"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        if (!(item instanceof ItemTag)) {
            return false;
        }
        ItemMeta meta = ((ItemTag)item).getItemMeta();
        if (meta instanceof BlockStateMeta && ((BlockStateMeta)meta).getBlockState() instanceof InventoryHolder) {
            return true;
        }
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && meta instanceof BundleMeta;
    }

    public static ItemInventory getFrom(ObjectTag _item) {
        if (!ItemInventory.describes(_item)) {
            return null;
        }
        return new ItemInventory((ItemTag)_item);
    }

    private InventoryTag getItemInventory() {
        InventoryHolder holder = (InventoryHolder)((BlockStateMeta)this.item.getItemMeta()).getBlockState();
        Inventory inv = holder instanceof Chest ? ((Chest)holder).getBlockInventory() : holder.getInventory();
        return InventoryTag.mirrorBukkitInventory(inv);
    }

    private ItemInventory(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("inventory_contents")) {
            return this.getInventoryContents().getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inventory")) {
            Deprecations.itemInventoryTag.warn(attribute.context);
            return this.getItemInventory().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public ListTag getInventoryContents() {
        if (this.item.getItemMeta() instanceof BlockStateMeta) {
            InventoryTag inventory = this.getItemInventory();
            if (inventory == null) {
                return null;
            }
            return InventoryContents.getFrom(inventory).getContents(false);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17)) {
            ListTag result = new ListTag();
            for (ItemStack item : ((BundleMeta)this.item.getItemMeta()).getItems()) {
                if (item == null || item.getType() == Material.AIR) continue;
                result.addObject(new ItemTag(item));
            }
            return result;
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ListTag items = this.getInventoryContents();
        return items != null ? items.identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "inventory_contents";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("inventory_contents") || mechanism.matches("inventory")) && mechanism.hasValue()) {
            if (mechanism.matches("inventory")) {
                Deprecations.itemInventoryTag.warn(mechanism.context);
            }
            Argument argument = new Argument("");
            argument.unsetValue();
            argument.object = mechanism.getValue();
            AbstractMap.SimpleEntry<Integer, InventoryTag> inventoryPair = Conversion.getInventory(argument, mechanism.context);
            if (inventoryPair == null || ((InventoryTag)inventoryPair.getValue()).getInventory() == null) {
                return;
            }
            ListTag items = InventoryContents.getFrom((ObjectTag)inventoryPair.getValue()).getContents(false);
            ItemStack[] itemArray = new ItemStack[items.size()];
            for (int i = 0; i < itemArray.length; ++i) {
                itemArray[i] = ((ItemTag)items.objectForms.get(i)).getItemStack().clone();
            }
            if (this.item.getItemMeta() instanceof BlockStateMeta) {
                BlockStateMeta bsm = (BlockStateMeta)this.item.getItemMeta();
                InventoryHolder invHolder = (InventoryHolder)bsm.getBlockState();
                if (items.size() > invHolder.getInventory().getSize()) {
                    mechanism.echoError("Invalid inventory_contents input size; expected " + invHolder.getInventory().getSize() + " or less.");
                    return;
                }
                invHolder.getInventory().setContents(itemArray);
                bsm.setBlockState((BlockState)invHolder);
                this.item.setItemMeta((ItemMeta)bsm);
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17)) {
                BundleMeta bundle = (BundleMeta)this.item.getItemMeta();
                bundle.setItems(Arrays.asList(itemArray));
                this.item.setItemMeta((ItemMeta)bundle);
            }
        }
    }
}

