/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.utilities;

import java.io.File;
import java.io.FilenameFilter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.aufdemrand.denizencore.objects.CustomObject;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class CoreUtilities {
    public static final Map<Class<? extends dObject>, TypeComparisonRunnable> typeCheckers = new HashMap<Class<? extends dObject>, TypeComparisonRunnable>();
    static Random random;
    static FilenameFilter scriptsFilter;

    public static String stringifyNullPass(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static dObject fixType(dObject input, TagContext context) {
        if (input instanceof Element) {
            return ObjectFetcher.pickObjectFor(input.toString(), context);
        }
        return input;
    }

    public static void autoPropertyMechanism(dObject object, Mechanism mechanism) {
        PropertyParser.ClassPropertiesInfo properties = PropertyParser.propertiesByClass.get(object.getClass());
        if (properties == null) {
            return;
        }
        PropertyParser.PropertyGetter specificGetter = properties.propertiesByMechanism.get(mechanism.getName());
        if (specificGetter != null) {
            Property prop = specificGetter.get(object);
            if (prop == null) {
                return;
            }
            prop.adjust(mechanism);
            return;
        }
        for (PropertyParser.PropertyGetter listGetter : properties.propertiesAnyMechs) {
            Property prop = listGetter.get(object);
            if (prop == null) continue;
            prop.adjust(mechanism);
            if (!mechanism.fulfilled()) continue;
            return;
        }
    }

    public static dObject autoPropertyTagObject(dObject object, Attribute attribute) {
        if (attribute.isComplete()) {
            return null;
        }
        PropertyParser.ClassPropertiesInfo properties = PropertyParser.propertiesByClass.get(object.getClass());
        if (properties == null) {
            return null;
        }
        PropertyParser.PropertyGetter specificGetter = properties.propertiesByTag.get(attribute.getAttributeWithoutContext(1));
        if (specificGetter != null) {
            Property prop = specificGetter.get(object);
            if (prop == null) {
                return null;
            }
            return prop.getObjectAttribute(attribute);
        }
        for (PropertyParser.PropertyGetter listGetter : properties.propertiesAnyTags) {
            dObject returned;
            Property prop = listGetter.get(object);
            if (prop == null || (returned = prop.getObjectAttribute(attribute)) == null) continue;
            return returned;
        }
        return null;
    }

    public static String autoPropertyTag(dObject object, Attribute attribute) {
        if (attribute.isComplete()) {
            return null;
        }
        PropertyParser.ClassPropertiesInfo properties = PropertyParser.propertiesByClass.get(object.getClass());
        if (properties == null) {
            return null;
        }
        PropertyParser.PropertyGetter specificGetter = properties.propertiesByTag.get(attribute.getAttributeWithoutContext(1));
        if (specificGetter != null) {
            Property prop = specificGetter.get(object);
            if (prop == null) {
                return null;
            }
            return prop.getAttribute(attribute);
        }
        for (PropertyParser.PropertyGetter listGetter : properties.propertiesAnyTags) {
            String returned;
            Property prop = listGetter.get(object);
            if (prop == null || (returned = prop.getAttribute(attribute)) == null) continue;
            return returned;
        }
        return null;
    }

    public static dObject autoAttrib(Property inp, Attribute attribute) {
        if (attribute.isComplete()) {
            return null;
        }
        return inp.getObjectAttribute(attribute);
    }

    public static dObject autoAttribTyped(dObject inp, Attribute attribute) {
        return CoreUtilities.autoAttrib(CoreUtilities.fixType(inp, attribute.context), attribute);
    }

    public static dObject autoAttrib(dObject inp, Attribute attribute) {
        if (inp == null) {
            dB.echoError("Tag parse failed (null return) for tag <" + attribute.toString() + ">!");
            return null;
        }
        if (attribute.isComplete()) {
            return inp;
        }
        return inp.getObjectAttribute(attribute);
    }

    public static <T extends dObject> T asType(dObject inp, Class<T> type, TagContext context) {
        T temp;
        if (inp.getClass() == type) {
            return (T)inp;
        }
        if (type == Element.class) {
            return (T)new Element(inp.toString());
        }
        if (inp instanceof dObject.ObjectAttributable && (temp = ((dObject.ObjectAttributable)inp).asObjectType(type, context)) != null) {
            return temp;
        }
        return ObjectFetcher.getObjectFrom(type, inp.toString(), context);
    }

    public static void registerTypeAsNoOtherTypeCode(Class<? extends dObject> type, final String knownCode) {
        typeCheckers.put(type, new TypeComparisonRunnable(){

            @Override
            public boolean canBecome(dObject inp) {
                String code;
                String simple = inp.identifySimple();
                int atIndex = simple.indexOf(64);
                return atIndex == -1 || (code = simple.substring(0, atIndex)).equals(knownCode);
            }
        });
    }

    public static void registerTypeAsTrueAlways(Class<? extends dObject> type) {
        typeCheckers.put(type, new TypeComparisonRunnable(){

            @Override
            public boolean canBecome(dObject inp) {
                return true;
            }
        });
    }

    public static boolean canPossiblyBeType(dObject inp, Class<? extends dObject> type) {
        if (inp.getClass() == type) {
            return true;
        }
        TypeComparisonRunnable comp = typeCheckers.get(type);
        if (comp != null && !comp.canBecome(inp)) {
            return false;
        }
        return ObjectFetcher.checkMatch(type, inp.toString());
    }

    public static Random getRandom() {
        return random;
    }

    public static String bigDecToString(BigDecimal input) {
        String temp = input.toString();
        if (temp.endsWith(".0")) {
            return temp.substring(0, temp.length() - 2);
        }
        return temp;
    }

    public static String doubleToString(double input) {
        String temp = String.valueOf(input);
        if (temp.endsWith(".0")) {
            return temp.substring(0, temp.length() - 2);
        }
        return temp;
    }

    public static List<File> listDScriptFiles(File dir) {
        File[] entries;
        ArrayList<File> files = new ArrayList<File>();
        for (File file : entries = dir.listFiles()) {
            if (scriptsFilter == null || scriptsFilter.accept(dir, file.getName())) {
                files.add(file);
            }
            if (!file.isDirectory()) continue;
            files.addAll(CoreUtilities.listDScriptFiles(file));
        }
        return files;
    }

    public static List<String> split(String str, char c) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            strings.add(str.substring(start, i));
            start = i + 1;
        }
        strings.add(str.substring(start, str.length()));
        return strings;
    }

    public static String concat(List<String> str, String split) {
        StringBuilder sb = new StringBuilder();
        if (str.size() > 0) {
            sb.append(str.get(0));
        }
        for (int i = 1; i < str.size(); ++i) {
            sb.append(split).append(str.get(i));
        }
        return sb.toString();
    }

    public static List<String> split(String str, char c, int max) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            strings.add(str.substring(start, i));
            start = i + 1;
            if (strings.size() + 1 == max) break;
        }
        strings.add(str.substring(start, str.length()));
        if (dB.verbose) {
            dB.log("Splitting " + str + " around " + c + " limited to " + max + " returns " + CoreUtilities.concat(strings, ":::"));
        }
        return strings;
    }

    public static String toLowerCase(String input) {
        char[] data = input.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] < 'A' || data[i] > 'Z') continue;
            int n = i;
            data[n] = (char)(data[n] - -32);
        }
        return new String(data);
    }

    public static String getXthArg(int argc, String args) {
        char[] data = args.toCharArray();
        StringBuilder nArg = new StringBuilder();
        int arg = 0;
        boolean x = false;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ') {
                if (++arg <= argc) continue;
                return nArg.toString();
            }
            if (arg != argc) continue;
            nArg.append(data[i]);
        }
        return nArg.toString();
    }

    public static boolean xthArgEquals(int argc, String args, String input) {
        char[] data = args.toCharArray();
        char[] data2 = input.toCharArray();
        int arg = 0;
        int x = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ') {
                ++arg;
                continue;
            }
            if (arg != argc) continue;
            if (x == data2.length) {
                return false;
            }
            if (data2[x++] == data[i]) continue;
            return false;
        }
        return x == data2.length;
    }

    public static String getClosestOption(List<String> strs, String opt) {
        int minDist = Integer.MAX_VALUE;
        opt = CoreUtilities.toLowerCase(opt);
        String closest = "";
        for (String cmd : strs) {
            String comp = CoreUtilities.toLowerCase(cmd);
            int distance = CoreUtilities.getLevenshteinDistance(opt, comp);
            if (minDist <= distance) continue;
            minDist = distance;
            closest = cmd;
        }
        return closest;
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    static {
        CoreUtilities.registerTypeAsTrueAlways(Element.class);
        CoreUtilities.registerTypeAsTrueAlways(dList.class);
        CoreUtilities.registerTypeAsNoOtherTypeCode(dScript.class, "s");
        CoreUtilities.registerTypeAsNoOtherTypeCode(Duration.class, "d");
        CoreUtilities.registerTypeAsNoOtherTypeCode(CustomObject.class, "custom");
        CoreUtilities.registerTypeAsNoOtherTypeCode(ScriptQueue.class, "q");
        random = new Random();
        scriptsFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String fileName) {
                if (fileName.startsWith(".")) {
                    return false;
                }
                String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
                return ext.equalsIgnoreCase("YML") || ext.equalsIgnoreCase("DSCRIPT");
            }
        };
    }

    public static abstract class TypeComparisonRunnable {
        public abstract boolean canBecome(dObject var1);
    }
}

