/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.reflect.Field;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;

public class BlockPhysicsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockPhysicsScriptEvent instance;
    public LocationTag location;
    public MaterialTag material;
    public BlockPhysicsEvent event;
    public static Field PHYSICS_EVENT_DATA;

    public BlockPhysicsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("physics")) {
            return false;
        }
        return this.couldMatchBlock(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!BlockPhysicsScriptEvent.tryMaterial(this.material, path.eventArgLowerAt(0))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "BlockPhysics";
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "new_material": {
                try {
                    BlockData data = (BlockData)PHYSICS_EVENT_DATA.get(this.event);
                    return new MaterialTag(data);
                }
                catch (Throwable ex) {
                    Debug.echoError(ex);
                }
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        Material changedType = event.getChangedType();
        if (changedType == Material.REDSTONE_WIRE || changedType == Material.COMPARATOR || changedType == Material.REPEATER) {
            return;
        }
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(this.location.getBlock());
        this.event = event;
        this.fire((Event)event);
    }

    static {
        PHYSICS_EVENT_DATA = ReflectionHelper.getFields(BlockPhysicsEvent.class).getFirstOfType(BlockData.class);
    }
}

