/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.aufdemrand.denizencore.DenizenImplementation;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.events.core.DeltaTimeScriptEvent;
import net.aufdemrand.denizencore.events.core.SystemTimeScriptEvent;
import net.aufdemrand.denizencore.scripts.ScriptHelper;
import net.aufdemrand.denizencore.scripts.commands.CommandRegistry;
import net.aufdemrand.denizencore.scripts.queues.ScriptEngine;
import net.aufdemrand.denizencore.utilities.debugging.LogInterceptor;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.scheduling.Schedulable;

public class DenizenCore {
    public static final String VERSION;
    static CommandRegistry commandRegistry;
    static ScriptEngine scriptEngine;
    public static LogInterceptor logInterceptor;
    public static Thread MAIN_THREAD;
    public static long currentTimeMillis;
    static DenizenImplementation implementation;
    public static final List<Schedulable> scheduled;
    static int tMS;
    public static long serverTimeMillis;

    public static CommandRegistry getCommandRegistry() {
        return commandRegistry;
    }

    public static void setCommandRegistry(CommandRegistry registry) {
        commandRegistry = registry;
    }

    public static ScriptEngine getScriptEngine() {
        return scriptEngine;
    }

    public static DenizenImplementation getImplementation() {
        return implementation;
    }

    public static void init(DenizenImplementation implementation) {
        currentTimeMillis = System.currentTimeMillis();
        DenizenCore.implementation = implementation;
        MAIN_THREAD = implementation.getMainThread();
        dB.log("Initializing Denizen Core v" + VERSION + ", implementation for " + implementation.getImplementationName() + " version " + implementation.getImplementationVersion());
        scriptEngine = new ScriptEngine();
        ScriptEvent.registerCoreEvents();
    }

    public static void initSecondary() {
    }

    public static void loadScripts() {
        try {
            ScriptEvent.worldContainers.clear();
            implementation.preScriptReload();
            ScriptHelper.resetError();
            ScriptHelper.reloadScripts();
            OldEventManager.scanWorldEvents();
            ScriptEvent.reload();
            implementation.onScriptReload();
        }
        catch (Exception ex) {
            implementation.debugMessage("Error loading scripts:");
            implementation.debugException(ex);
        }
    }

    public static void reloadScripts() {
        DenizenCore.loadScripts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(Schedulable sched) {
        List<Schedulable> list = scheduled;
        synchronized (list) {
            scheduled.add(sched);
        }
    }

    static void oncePerSecond() {
        SystemTimeScriptEvent.instance.checkTime();
        DeltaTimeScriptEvent.instance.checkTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(int ms_elapsed) {
        serverTimeMillis += (long)ms_elapsed;
        currentTimeMillis = System.currentTimeMillis();
        tMS += ms_elapsed;
        while (tMS > 1000) {
            tMS -= 1000;
            DenizenCore.oncePerSecond();
        }
        List<Schedulable> list = scheduled;
        synchronized (list) {
            for (int i = 0; i < scheduled.size(); ++i) {
                if (scheduled.get(i).tick((float)ms_elapsed / 1000.0f)) continue;
                scheduled.remove(i--);
            }
        }
    }

    static {
        logInterceptor = new LogInterceptor();
        currentTimeMillis = System.currentTimeMillis();
        String version = "UNKNOWN";
        try {
            InputStream is = DenizenCore.class.getClassLoader().getResourceAsStream("denizencore.properties");
            if (is == null) {
                throw new FileNotFoundException("denizencore.properties not found in jar file");
            }
            Properties properties = new Properties();
            properties.load(is);
            version = properties.getProperty("version") + " (Build " + properties.getProperty("build") + ")";
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VERSION = version;
        scheduled = new ArrayList<Schedulable>();
        tMS = 0;
        serverTimeMillis = 1L;
    }
}

