/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects.properties;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class PropertyParser {
    public static Map<Class<? extends dObject>, ClassPropertiesInfo> propertiesByClass = new HashMap<Class<? extends dObject>, ClassPropertiesInfo>();
    public static List<Property> empty = new ArrayList<Property>();

    public static void registerPropertyGetter(PropertyGetter getter, Class<? extends dObject> object, String[] tags, String[] mechs) {
        ClassPropertiesInfo propInfo = propertiesByClass.get(object);
        if (propInfo == null) {
            propInfo = new ClassPropertiesInfo();
            propertiesByClass.put(object, propInfo);
        }
        propInfo.allProperties.add(getter);
        if (tags != null) {
            for (String tag : tags) {
                propInfo.propertiesByTag.put(tag, getter);
            }
        } else {
            propInfo.propertiesAnyTags.add(getter);
        }
        if (mechs != null) {
            for (String mech : mechs) {
                propInfo.propertiesByMechanism.put(mech, getter);
            }
        } else {
            propInfo.propertiesAnyMechs.add(getter);
        }
    }

    public static String[] getStringField(Class property, String fieldName) {
        try {
            Field f = property.getDeclaredField(fieldName);
            return (String[])f.get(null);
        }
        catch (IllegalAccessException e) {
            dB.echoError("Invalid property field '" + fieldName + "' for property class '" + property.getSimpleName() + "': field is not a Set: " + e.getMessage() + "!");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public static void registerProperty(Class property, Class<? extends dObject> object, PropertyGetter getter) {
        PropertyParser.registerPropertyGetter(getter, object, PropertyParser.getStringField(property, "handledTags"), PropertyParser.getStringField(property, "handledMechs"));
    }

    public static void registerProperty(Class property, Class<? extends dObject> object) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CallSite site = LambdaMetafactory.metafactory(lookup, "get", MethodType.methodType(PropertyGetter.class), MethodType.methodType(Property.class, dObject.class), lookup.findStatic(property, "getFrom", MethodType.methodType(property, dObject.class)), MethodType.methodType(property, dObject.class));
            PropertyGetter getter = site.getTarget().invoke();
            PropertyParser.registerProperty(property, object, getter);
        }
        catch (Throwable e) {
            dB.echoError("Unable to register property '" + property.getSimpleName() + "'!");
            dB.echoError(e);
        }
    }

    public static String getPropertiesString(dObject object) {
        ClassPropertiesInfo properties = propertiesByClass.get(object.getClass());
        if (properties == null) {
            return "";
        }
        StringBuilder prop_string = new StringBuilder(properties.allProperties.size() * 10);
        for (PropertyGetter getter : properties.allProperties) {
            String description;
            Property property = getter.get(object);
            if (property == null || (description = property.getPropertyString()) == null) continue;
            prop_string.append(property.getPropertyId()).append('=').append(description.replace(';', '\u2011')).append(';');
        }
        if (prop_string.length() > 0) {
            return "[" + prop_string.substring(0, prop_string.length() - 1) + "]";
        }
        return "";
    }

    public static List<Property> getProperties(dObject object, String attribLow) {
        ClassPropertiesInfo properties = propertiesByClass.get(object.getClass());
        if (properties == null) {
            return empty;
        }
        PropertyGetter getter = properties.propertiesByTag.get(attribLow);
        if (getter != null) {
            Property prop = getter.get(object);
            if (prop == null) {
                return empty;
            }
            return Collections.singletonList(getter.get(object));
        }
        return PropertyParser.getProperties(object);
    }

    public static List<Property> getProperties(dObject object) {
        ClassPropertiesInfo properties = propertiesByClass.get(object.getClass());
        if (properties == null) {
            return empty;
        }
        ArrayList<Property> props = new ArrayList<Property>(properties.allProperties.size());
        for (PropertyGetter getter : properties.allProperties) {
            Property prop = getter.get(object);
            if (prop == null) continue;
            props.add(prop);
        }
        return props;
    }

    public static class ClassPropertiesInfo {
        public List<PropertyGetter> allProperties = new ArrayList<PropertyGetter>();
        public List<PropertyGetter> propertiesAnyTags = new ArrayList<PropertyGetter>();
        public List<PropertyGetter> propertiesAnyMechs = new ArrayList<PropertyGetter>();
        public Map<String, PropertyGetter> propertiesByTag = new HashMap<String, PropertyGetter>();
        public Map<String, PropertyGetter> propertiesByMechanism = new HashMap<String, PropertyGetter>();
    }

    @FunctionalInterface
    public static interface PropertyGetter {
        public Property get(dObject var1);
    }
}

