/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class GameRuleCommand
extends AbstractCommand {
    public GameRuleCommand() {
        this.setName("gamerule");
        this.setSyntax("gamerule [<world>] [<rule>] [<value>]");
        this.setRequiredArguments(3, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(WorldTag.class)) {
                scriptEntry.addObject("world", arg.asType(WorldTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("gamerule")) {
                scriptEntry.addObject("gamerule", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("value")) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("world")) {
            throw new InvalidArgumentsException("Must specify a world!");
        }
        if (!scriptEntry.hasObject("gamerule")) {
            throw new InvalidArgumentsException("Must specify a gamerule!");
        }
        if (!scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify a value!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        WorldTag world = (WorldTag)scriptEntry.getObjectTag("world");
        ElementTag gamerule = scriptEntry.getElement("gamerule");
        ElementTag value = scriptEntry.getElement("value");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), world.debug() + gamerule.debug() + value.debug());
        }
        if (!world.getWorld().setGameRuleValue(gamerule.asString(), value.asString())) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Invalid gamerule!");
        }
    }
}

