/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DisplayItemCommand
extends AbstractCommand
implements Listener {
    public final HashSet<UUID> protectedEntities = new HashSet();

    public DisplayItemCommand() {
        this.setName("displayitem");
        this.setSyntax("displayitem [<item>] [<location>] (duration:<value>)");
        this.setRequiredArguments(2, 3);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (Material material : Material.values()) {
            if (!material.isItem()) continue;
            addOne.accept(material.name());
        }
        for (String itemScript : ItemScriptHelper.item_scripts.keySet()) {
            addOne.accept(itemScript);
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesArgumentType(DurationTag.class) && !scriptEntry.hasObject("duration")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matchesArgumentType(LocationTag.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (arg.matchesArgumentType(ItemTag.class) && !scriptEntry.hasObject("item")) {
                scriptEntry.addObject("item", arg.asType(ItemTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("item")) {
            throw new InvalidArgumentsException("Must specify an item to display.");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("duration")) {
            scriptEntry.addObject("duration", new DurationTag(60));
        }
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        if (this.protectedEntities.contains(event.getEntity().getUniqueId()) || this.protectedEntities.contains(event.getTarget().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemInventoryPickup(InventoryPickupItemEvent event) {
        if (this.protectedEntities.contains(event.getItem().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemEntityPickup(EntityPickupItemEvent event) {
        if (this.protectedEntities.contains(event.getItem().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    public void onItemDespawn(ItemDespawnEvent event) {
        if (this.protectedEntities.contains(event.getEntity().getUniqueId())) {
            event.setCancelled(true);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> {
                if (event.getEntity().isValid() && !event.getEntity().isDead()) {
                    NMSHandler.getEntityHelper().setTicksLived((Entity)event.getEntity(), -1000);
                }
            }, 1L);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ItemTag item = (ItemTag)scriptEntry.getObjectTag("item");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), item, duration, location);
        }
        Item dropped = location.getWorld().dropItem((Location)location.getBlockLocation().clone().add(0.5, 1.5, 0.5), item.getItemStack());
        dropped.setVelocity(new Vector(0, 0, 0));
        dropped.setGravity(false);
        dropped.setPickupDelay(Short.MAX_VALUE);
        int ticks = duration.getTicksAsInt();
        NMSHandler.getEntityHelper().setTicksLived((Entity)dropped, ticks <= 0 ? Short.MIN_VALUE : -ticks);
        if (!dropped.isValid()) {
            Debug.echoDebug((Debuggable)scriptEntry, "Item failed to spawned (likely blocked by some plugin).");
            return;
        }
        UUID itemUUID = dropped.getUniqueId();
        this.protectedEntities.add(itemUUID);
        scriptEntry.addObject("dropped", new EntityTag((Entity)dropped));
        if (ticks > 0) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> {
                this.protectedEntities.remove(itemUUID);
                if (dropped.isValid() && !dropped.isDead()) {
                    dropped.remove();
                }
            }, (long)ticks);
        }
    }
}

