/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptHelper;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.core.FlagCommand;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.data.ActionableDataProvider;
import com.denizenscript.denizencore.utilities.data.DataAction;
import com.denizenscript.denizencore.utilities.data.DataActionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.AbstractMap;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryCommand
extends AbstractCommand {
    public InventoryCommand() {
        this.setName("inventory");
        this.setSyntax("inventory [open/close/copy/move/swap/set/keep/exclude/fill/clear/update/adjust <mechanism>:<value>/flag <name>(:<action>)[:<value>] (duration:<duration>)] (destination:<inventory>) (origin:<inventory>/<item>|...) (slot:<slot>)");
        this.setRequiredArguments(1, 6);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (String mech : PropertyParser.propertiesByClass.get(ItemTag.class).propertiesByMechanism.keySet()) {
            addOne.accept(mech);
        }
        if (arg.contains(":")) {
            Consumer<String> addAll = s -> {
                addOne.accept("o:" + s);
                addOne.accept("origin:" + s);
                addOne.accept("d:" + s);
                addOne.accept("dest:" + s);
                addOne.accept("destination:" + s);
            };
            for (InventoryTag inventoryTag : NotableManager.notesByType.get(InventoryTag.class)) {
                addAll.accept(inventoryTag.noteName);
            }
            for (String string : InventoryScriptHelper.inventoryScripts.keySet()) {
                addAll.accept(string);
            }
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean isAdjust = false;
        boolean isFlag = false;
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin", "o", "source", "items", "item", "i", "from", "f") && (arg.matchesArgumentTypes(InventoryTag.class, EntityTag.class, LocationTag.class, MapTag.class) || arg.matchesArgumentList(ItemTag.class))) {
                scriptEntry.addObject("origin", Conversion.getInventory(arg, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesPrefix("destination", "dest", "d", "target", "to", "t") && arg.matchesArgumentTypes(InventoryTag.class, EntityTag.class, LocationTag.class)) {
                scriptEntry.addObject("destination", Conversion.getInventory(arg, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("slot") && arg.matchesPrefix("slot", "s")) {
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("actions") && arg.matchesEnumList(Action.values())) {
                scriptEntry.addObject("actions", arg.asType(ListTag.class).filter(Action.values()));
                isAdjust = arg.toString().equalsIgnoreCase("adjust");
                isFlag = arg.toString().equalsIgnoreCase("flag");
                continue;
            }
            if (!scriptEntry.hasObject("mechanism") && isAdjust) {
                if (arg.hasPrefix()) {
                    scriptEntry.addObject("mechanism", new ElementTag(arg.getPrefix().getValue()));
                    scriptEntry.addObject("mechanism_value", arg.object);
                    continue;
                }
                scriptEntry.addObject("mechanism", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesPrefix("duration") && arg.matchesArgumentType(DurationTag.class) && isFlag) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("flag_action") && isFlag) {
                scriptEntry.addObject("flag_action", DataActionHelper.parse((ActionableDataProvider)new FlagCommand.FlagActionProvider(), arg, scriptEntry.context));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("actions")) {
            throw new InvalidArgumentsException("Must specify an Inventory action!");
        }
        if (isAdjust && !scriptEntry.hasObject("mechanism")) {
            throw new InvalidArgumentsException("Inventory adjust must have a mechanism!");
        }
        if (isAdjust && !scriptEntry.hasObject("slot")) {
            throw new InvalidArgumentsException("Inventory adjust must have an explicit slot!");
        }
        if (isFlag && !scriptEntry.hasObject("flag_action")) {
            throw new InvalidArgumentsException("Inventory flag must have a flag action!");
        }
        scriptEntry.defaultObject("slot", new ElementTag(1));
        scriptEntry.defaultObject("destination", Utilities.entryHasPlayer(scriptEntry) ? new AbstractMap.SimpleEntry<Integer, InventoryTag>(0, Utilities.getEntryPlayer(scriptEntry).getInventory()) : null);
        if (!scriptEntry.hasObject("destination")) {
            throw new InvalidArgumentsException("Must specify a Destination Inventory!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        int slotId;
        List actions = (List)scriptEntry.getObject("actions");
        AbstractMap.SimpleEntry originentry = (AbstractMap.SimpleEntry)scriptEntry.getObject("origin");
        InventoryTag origin = originentry != null ? (InventoryTag)originentry.getValue() : null;
        AbstractMap.SimpleEntry destinationentry = (AbstractMap.SimpleEntry)scriptEntry.getObject("destination");
        InventoryTag destination = (InventoryTag)destinationentry.getValue();
        ElementTag slot = scriptEntry.getElement("slot");
        ElementTag mechanism = scriptEntry.getElement("mechanism");
        ObjectTag mechanismValue = (ObjectTag)scriptEntry.getObjectTag("mechanism_value");
        DataAction flagAction = (DataAction)scriptEntry.getObject("flag_action");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), ArgumentHelper.debugObj("actions", actions.toString()), destination, origin, mechanism, mechanismValue, flagAction, duration, slot);
        }
        if ((slotId = SlotHelper.nameToIndexFor(slot.asString(), destination.getInventory().getHolder())) < 0) {
            if (slotId == -1) {
                Debug.echoError(scriptEntry.getResidingQueue(), "The input '" + slot.asString() + "' is not a valid slot (unrecognized)!");
            } else {
                Debug.echoError(scriptEntry.getResidingQueue(), "The input '" + slot.asString() + "' is not a valid slot (negative values are invalid)!");
            }
            return;
        }
        InventoryTag.trackTemporaryInventory(destination);
        if (origin != null) {
            InventoryTag.trackTemporaryInventory(origin);
        }
        block17: for (String action : actions) {
            switch (Action.valueOf(action.toUpperCase())) {
                case OPEN: {
                    if (destination.getIdType().equals("workbench") || destination.getIdHolder().equals(new ElementTag("workbench"))) {
                        Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().openWorkbench(null, true);
                        break;
                    }
                    Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().openInventory(destination.getInventory());
                    break;
                }
                case CLOSE: {
                    Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().closeInventory();
                    break;
                }
                case COPY: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    this.replace(origin, destination);
                    break;
                }
                case MOVE: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    this.replace(origin, destination);
                    origin.clear();
                    break;
                }
                case SWAP: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    InventoryTag temp = new InventoryTag(destination.getInventory().getContents());
                    this.replace(origin, destination);
                    this.replace(temp, origin);
                    break;
                }
                case ADD: {
                    Deprecations.oldInventoryCommands.warn(scriptEntry);
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.add(slotId, origin.getContents());
                    break;
                }
                case REMOVE: {
                    Deprecations.oldInventoryCommands.warn(scriptEntry);
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    this.remove(destination.getInventory(), origin.getContents());
                    break;
                }
                case SET: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    destination.setSlots(slotId, origin.getContents(), (Integer)originentry.getKey());
                    break;
                }
                case KEEP: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    ItemStack[] items = origin.getContents();
                    for (ItemStack invStack : destination.getInventory()) {
                        if (invStack == null) continue;
                        boolean keep = false;
                        for (ItemStack item : items) {
                            if (!invStack.isSimilar(item)) continue;
                            keep = true;
                            break;
                        }
                        if (keep) continue;
                        destination.getInventory().remove(invStack);
                    }
                    continue block17;
                }
                case EXCLUDE: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    int oldCount = destination.count(null, false);
                    int newCount = -1;
                    while (oldCount != newCount) {
                        oldCount = newCount;
                        this.remove(destination.getInventory(), origin.getContents());
                        newCount = destination.count(null, false);
                    }
                    break;
                }
                case FILL: {
                    if (origin == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin argument!");
                        return;
                    }
                    int oldCount = destination.count(null, false);
                    int newCount = -1;
                    while (oldCount != newCount) {
                        oldCount = newCount;
                        newCount = destination.add(0, origin.getContents()).count(null, false);
                    }
                    break;
                }
                case CLEAR: {
                    destination.clear();
                    break;
                }
                case UPDATE: {
                    if (destination.idHolder instanceof PlayerTag) {
                        ((PlayerTag)destination.idHolder).getPlayerEntity().updateInventory();
                        break;
                    }
                    Debug.echoError("Only player inventories can be force-updated!");
                    break;
                }
                case ADJUST: {
                    ItemTag toAdjust = new ItemTag(destination.getInventory().getItem(slotId));
                    toAdjust.safeAdjust(new Mechanism(mechanism.asString(), mechanismValue, scriptEntry.getContext()));
                    NMSHandler.getItemHelper().setInventoryItem(destination.getInventory(), toAdjust.getItemStack(), slotId);
                    break;
                }
                case FLAG: {
                    ItemTag toFlag = new ItemTag(destination.getInventory().getItem(slotId));
                    FlagCommand.FlagActionProvider provider = (FlagCommand.FlagActionProvider)flagAction.provider;
                    provider.expiration = duration == null ? null : new TimeTag(TimeTag.now().millis() + duration.getMillis());
                    provider.tracker = toFlag.getFlagTracker();
                    flagAction.execute(scriptEntry.context);
                    toFlag.reapplyTracker(provider.tracker);
                    NMSHandler.getItemHelper().setInventoryItem(destination.getInventory(), toFlag.getItemStack(), slotId);
                }
            }
        }
    }

    public void replace(InventoryTag origin, InventoryTag destination) {
        if (destination.getSize() < origin.getSize()) {
            destination.clear();
            destination.add(0, origin.getContents());
        } else {
            destination.setContents(origin.getContents());
        }
    }

    public void remove(Inventory inventory, ItemStack[] items) {
        for (ItemStack item : items) {
            if (item == null) continue;
            inventory.removeItem(new ItemStack[]{item.clone()});
        }
    }

    private static enum Action {
        OPEN,
        CLOSE,
        COPY,
        MOVE,
        SWAP,
        ADD,
        REMOVE,
        SET,
        KEEP,
        EXCLUDE,
        FILL,
        CLEAR,
        UPDATE,
        ADJUST,
        FLAG;

    }
}

