/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.Map;
import java.util.function.Consumer;

public class RunCommand
extends AbstractCommand
implements Holdable {
    public RunCommand() {
        this.setName("run");
        this.setSyntax("run [<script>] (path:<name>) (def:<element>|.../defmap:<map>/def.<name>:<value>) (id:<name>) (speed:<value>/instantly) (delay:<value>)");
        this.setRequiredArguments(1, -1);
        this.isProcedural = true;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (ScriptContainer script : ScriptRegistry.scriptContainers.values()) {
            if (!(script instanceof TaskScriptContainer)) continue;
            addOne.accept(script.getName());
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        MapTag defMap = new MapTag();
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesPrefix("i", "id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("d", "def", "define", "c", "context")) {
                scriptEntry.addObject("definitions", arg.asType(ListTag.class));
                continue;
            }
            if (arg.matchesPrefix("defmap") && arg.matchesArgumentType(MapTag.class)) {
                defMap.map.putAll(arg.asType(MapTag.class).map);
                continue;
            }
            if (arg.matches("instant", "instantly")) {
                scriptEntry.addObject("instant", new ElementTag(true));
                continue;
            }
            if (arg.matchesPrefix("delay") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("delay", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matches("local", "locally")) {
                Deprecations.locallyArgument.warn(scriptEntry);
                scriptEntry.addObject("script", scriptEntry.getScript());
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrefix("speed") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("speed", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.hasPrefix() && arg.getPrefix().getRawValue().startsWith("def.")) {
                defMap.putObject(arg.getPrefix().getRawValue().substring("def.".length()), arg.object);
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(ScriptTag.class) && arg.limitToOnlyPrefix("script")) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!arg.hasPrefix() && arg.getRawValue().startsWith("def.") && arg.getRawValue().contains(":")) {
                int colon = arg.getRawValue().indexOf(58);
                defMap.putObject(arg.getRawValue().substring("def.".length(), colon), new ElementTag(arg.getRawValue().substring(colon + 1)));
                continue;
            }
            if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("path") && !arg.hasPrefix() && arg.asElement().asString().contains(".")) {
                int dotIndex;
                String path = arg.asElement().asString();
                ScriptTag script = new ScriptTag(path.substring(0, dotIndex = path.indexOf(46)));
                if (!script.isValid()) {
                    arg.reportUnhandled();
                    continue;
                }
                scriptEntry.addObject("script", script);
                scriptEntry.addObject("path", new ElementTag(path.substring(dotIndex + 1)));
                continue;
            }
            if (!scriptEntry.hasObject("path") && arg.limitToOnlyPrefix("path")) {
                if (!arg.hasPrefix() && scriptEntry.hasObject("script")) {
                    Debug.echoError("Run command path is missing required 'path:' prefix.");
                }
                scriptEntry.addObject("path", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be run.");
        }
        if (!defMap.map.isEmpty()) {
            scriptEntry.addObject("def_map", defMap);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        String path;
        ElementTag pathElement = scriptEntry.getElement("path");
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        ElementTag instant = scriptEntry.getElement("instant");
        ElementTag id = scriptEntry.getElement("id");
        DurationTag speed = (DurationTag)scriptEntry.getObjectTag("speed");
        DurationTag delay = (DurationTag)scriptEntry.getObjectTag("delay");
        MapTag defMap = (MapTag)scriptEntry.getObjectTag("def_map");
        String string = path = pathElement != null ? pathElement.asString() : null;
        if (script == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Script run failed (invalid script name)!");
            return;
        }
        if (!(path == null || script.getContainer().contains(path) && script.getContainer().getContents().isList(path))) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Script run failed (invalid path)!");
            return;
        }
        if (instant != null && instant.asBoolean()) {
            speed = new DurationTag(0);
        }
        ListTag definitions = (ListTag)scriptEntry.getObjectTag("definitions");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), script, pathElement, instant, speed, delay, id, defMap, definitions);
        }
        Consumer<ScriptQueue> configure = queue -> {
            if (delay != null) {
                queue.delayUntil(DenizenCore.serverTimeMillis + delay.getMillis());
            }
            if (scriptEntry.shouldWaitFor()) {
                queue.callBack(() -> scriptEntry.setFinished(true));
            }
            if (defMap != null) {
                for (Map.Entry<StringHolder, ObjectTag> val : defMap.map.entrySet()) {
                    queue.addDefinition(val.getKey().str, val.getValue());
                }
            }
            scriptEntry.addObject("created_queue", new QueueTag((ScriptQueue)queue));
            queue.procedural = scriptEntry.getResidingQueue().procedural;
        };
        String idString = id != null ? "FORCE:" + id.asString() : null;
        ScriptQueue result = ScriptUtilities.createAndStartQueue(script.getContainer(), path, scriptEntry.entryData, null, configure, speed, idString, definitions, scriptEntry);
        if (result == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Script run failed (are you sure it's a task script, and the path exists?)!");
            return;
        }
    }
}

