/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.Month;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;

public class TimeTag
implements ObjectTag,
Adjustable,
FlaggableObject {
    public ZonedDateTime instant;
    public static ZoneId UTC_Zone = ZoneId.of("UTC");
    String prefix = "Time";
    public static ObjectTagProcessor<TimeTag> tagProcessor = new ObjectTagProcessor();

    public static TimeTag now() {
        return new TimeTag(ZonedDateTime.now());
    }

    @Fetchable(value="time")
    public static TimeTag valueOf(String string, TagContext context) {
        List<String> coreParts;
        if (string == null) {
            return null;
        }
        if (string.startsWith("time@") && string.length() > "time@".length()) {
            string = string.substring("time@".length());
        }
        if ((coreParts = CoreUtilities.split(string, '_')).size() > 3) {
            return null;
        }
        List<String> dateParts = CoreUtilities.split(coreParts.get(0), '/');
        if (dateParts.size() != 3) {
            return null;
        }
        List<String> timeParts = null;
        if (coreParts.size() > 1 && (timeParts = CoreUtilities.split(coreParts.get(1), ':')).size() != 3 && timeParts.size() != 4) {
            return null;
        }
        try {
            int year = Integer.parseInt(dateParts.get(0));
            int month = Integer.parseInt(dateParts.get(1));
            int day = Integer.parseInt(dateParts.get(2));
            int hour = 0;
            int minute = 0;
            int second = 0;
            int millisecond = 0;
            if (timeParts != null) {
                hour = Integer.parseInt(timeParts.get(0));
                minute = Integer.parseInt(timeParts.get(1));
                second = Integer.parseInt(timeParts.get(2));
                if (timeParts.size() == 4) {
                    millisecond = Integer.parseInt(timeParts.get(3));
                }
            }
            ZoneOffset offset = ZoneOffset.UTC;
            if (coreParts.size() > 2) {
                offset = ZoneOffset.of(coreParts.get(2));
            }
            return new TimeTag(year, month, day, hour, minute, second, millisecond, offset);
        }
        catch (NumberFormatException ex) {
            if (context == null || context.showErrors()) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("time@")) {
            return true;
        }
        return TimeTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public TimeTag() {
    }

    public TimeTag(int year, int month, int day, int hour, int minute, int second, int millisecond, ZoneOffset offset) {
        this(ZonedDateTime.of(year, month, day, hour, minute, second, millisecond * 1000000, offset));
    }

    public TimeTag(ZonedDateTime instant) {
        this.instant = instant;
    }

    public TimeTag(long millis, ZoneId zone) {
        this(Instant.ofEpochSecond(millis / 1000L, millis % 1000L * 1000000L).atZone(zone));
    }

    public TimeTag(long millis) {
        this(millis, UTC_Zone);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public TimeTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "time";
    }

    public static String pad0(int value, int len) {
        String outputStr = String.valueOf(value);
        while (outputStr.length() < len) {
            outputStr = "0" + outputStr;
        }
        return outputStr;
    }

    @Override
    public String debuggable() {
        StringBuilder output = new StringBuilder();
        output.append("<G>time@ <Y>");
        output.append(TimeTag.pad0(this.instant.get(ChronoField.YEAR), 4)).append("<G> / <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.MONTH_OF_YEAR), 2)).append(" <G>(<GR>").append(Month.of(this.instant.get(ChronoField.MONTH_OF_YEAR)).name()).append("<G>)").append("<G> / <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.DAY_OF_MONTH), 2)).append(" <G>(<GR>").append(DayOfWeek.of(this.instant.get(ChronoField.DAY_OF_WEEK)).name()).append("<G>)").append("<G> _ <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.HOUR_OF_DAY), 2)).append("<G> : <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.MINUTE_OF_HOUR), 2)).append("<G> : <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.SECOND_OF_MINUTE), 2)).append("<G> : <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.MILLI_OF_SECOND), 4)).append("<G> _ <Y>").append(this.instant.getOffset().getId());
        return output.toString();
    }

    @Override
    public String identify() {
        StringBuilder output = new StringBuilder();
        output.append("time@");
        output.append(TimeTag.pad0(this.instant.get(ChronoField.YEAR), 4)).append("/").append(TimeTag.pad0(this.instant.get(ChronoField.MONTH_OF_YEAR), 2)).append("/").append(TimeTag.pad0(this.instant.get(ChronoField.DAY_OF_MONTH), 2)).append("_").append(TimeTag.pad0(this.instant.get(ChronoField.HOUR_OF_DAY), 2)).append(":").append(TimeTag.pad0(this.instant.get(ChronoField.MINUTE_OF_HOUR), 2)).append(":").append(TimeTag.pad0(this.instant.get(ChronoField.SECOND_OF_MINUTE), 2)).append(":").append(TimeTag.pad0(this.instant.get(ChronoField.MILLI_OF_SECOND), 4)).append("_").append(this.instant.getOffset().getId());
        return output.toString();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public int year() {
        return this.instant.get(ChronoField.YEAR);
    }

    public int month() {
        return this.instant.get(ChronoField.MONTH_OF_YEAR);
    }

    public int day() {
        return this.instant.get(ChronoField.DAY_OF_MONTH);
    }

    public int hour() {
        return this.instant.get(ChronoField.HOUR_OF_DAY);
    }

    public int minute() {
        return this.instant.get(ChronoField.MINUTE_OF_HOUR);
    }

    public int second() {
        return this.instant.get(ChronoField.SECOND_OF_MINUTE);
    }

    public int millisecondComponent() {
        return this.instant.get(ChronoField.MILLI_OF_SECOND);
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return new RedirectionFlagTracker(DenizenCore.serverFlagMap, "__time." + this.millis());
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        TimeTag.registerTag("year", (attribute, object) -> new ElementTag(object.year()), new String[0]);
        TimeTag.registerTag("month", (attribute, object) -> new ElementTag(object.month()), new String[0]);
        TimeTag.registerTag("month_name", (attribute, object) -> new ElementTag(Month.of(object.month()).name()), new String[0]);
        TimeTag.registerTag("days_in_month", (attribute, object) -> new ElementTag(YearMonth.of(object.year(), object.month()).lengthOfMonth()), new String[0]);
        TimeTag.registerTag("day", (attribute, object) -> new ElementTag(object.day()), new String[0]);
        TimeTag.registerTag("day_of_year", (attribute, object) -> new ElementTag(object.instant.get(ChronoField.DAY_OF_YEAR)), new String[0]);
        TimeTag.registerTag("day_of_week", (attribute, object) -> new ElementTag(object.instant.get(ChronoField.DAY_OF_WEEK)), new String[0]);
        TimeTag.registerTag("day_of_week_name", (attribute, object) -> new ElementTag(DayOfWeek.of(object.instant.get(ChronoField.DAY_OF_WEEK)).name()), new String[0]);
        TimeTag.registerTag("hour", (attribute, object) -> new ElementTag(object.hour()), new String[0]);
        TimeTag.registerTag("minute", (attribute, object) -> new ElementTag(object.minute()), new String[0]);
        TimeTag.registerTag("second", (attribute, object) -> new ElementTag(object.second()), new String[0]);
        TimeTag.registerTag("millisecond", (attribute, object) -> new ElementTag(object.millisecondComponent()), new String[0]);
        TimeTag.registerTag("epoch_millis", (attribute, object) -> new ElementTag(object.millis()), new String[0]);
        TimeTag.registerTag("time_zone_offset", (attribute, object) -> new ElementTag(object.instant.getOffset().getId()), new String[0]);
        TimeTag.registerTag("time_zone_id", (attribute, object) -> new ElementTag(object.instant.getZone().getId()), new String[0]);
        TimeTag.registerTag("time_zone_name", (attribute, object) -> new ElementTag(object.instant.getZone().getDisplayName(TextStyle.SHORT, Locale.ENGLISH)), new String[0]);
        TimeTag.registerTag("to_zone", (attribute, object) -> new TimeTag(object.instant.withZoneSameInstant(ZoneId.of(attribute.getContext(1)))), new String[0]);
        TimeTag.registerTag("to_local", (attribute, object) -> new TimeTag(object.instant.withZoneSameInstant(ZoneId.systemDefault())), new String[0]);
        TimeTag.registerTag("to_utc", (attribute, object) -> new TimeTag(object.instant.withZoneSameInstant(ZoneOffset.UTC)), new String[0]);
        TimeTag.registerTag("last_hour_of_day", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("time.last_hour_of_day[...] must have input.");
                return null;
            }
            int hour = attribute.getIntContext(1);
            int todayHour = object.hour();
            TimeTag result = new TimeTag(object.year(), object.month(), object.day(), 0, 0, 0, 0, object.instant.getOffset());
            if (hour > todayHour) {
                result = new TimeTag(result.instant.minusDays(1L));
            }
            return new TimeTag(result.instant.plusHours(hour));
        }, new String[0]);
        TimeTag.registerTag("next_hour_of_day", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("time.next_hour_of_day[...] must have input.");
                return null;
            }
            int hour = attribute.getIntContext(1);
            int todayHour = object.hour();
            TimeTag result = new TimeTag(object.year(), object.month(), object.day(), 0, 0, 0, 0, object.instant.getOffset());
            if (hour <= todayHour) {
                result = new TimeTag(result.instant.plusDays(1L));
            }
            return new TimeTag(result.instant.plusHours(hour));
        }, new String[0]);
        TimeTag.registerTag("last_day_of_week", (attribute, object) -> {
            DayOfWeek day;
            if (!attribute.hasContext(1)) {
                attribute.echoError("time.last_day_of_week[...] must have input.");
                return null;
            }
            try {
                day = DayOfWeek.valueOf(attribute.getContext(1).toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                attribute.echoError("'" + attribute.getContext(1) + "' is not a valid day-of-week.");
                return null;
            }
            ZonedDateTime time = object.instant;
            while (!time.getDayOfWeek().equals(day)) {
                time = time.minus(12L, ChronoUnit.HOURS);
            }
            TimeTag outTime = new TimeTag(time);
            return new TimeTag(outTime.year(), outTime.month(), outTime.day(), 0, 0, 0, 0, object.instant.getOffset());
        }, new String[0]);
        TimeTag.registerTag("next_day_of_week", (attribute, object) -> {
            DayOfWeek day;
            if (!attribute.hasContext(1)) {
                attribute.echoError("time.next_day_of_week[...] must have input.");
                return null;
            }
            try {
                day = DayOfWeek.valueOf(attribute.getContext(1).toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                attribute.echoError("'" + attribute.getContext(1) + "' is not a valid day-of-week.");
                return null;
            }
            ZonedDateTime time = object.instant;
            while (!time.getDayOfWeek().equals(day)) {
                time = time.plus(12L, ChronoUnit.HOURS);
            }
            TimeTag outTime = new TimeTag(time);
            return new TimeTag(outTime.year(), outTime.month(), outTime.day(), 0, 0, 0, 0, object.instant.getOffset());
        }, new String[0]);
        TimeTag.registerTag("last_day_of_month", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("time.last_day_of_month[...] must have input.");
                return null;
            }
            int day = attribute.getIntContext(1);
            if (day < 1 || day > 31) {
                return null;
            }
            if (object.day() < day) {
                if (object.month() == 1) {
                    return new TimeTag(object.year() - 1, 12, day, 0, 0, 0, 0, object.instant.getOffset());
                }
                return new TimeTag(object.year(), object.month() - 1, day, 0, 0, 0, 0, object.instant.getOffset());
            }
            return new TimeTag(object.year(), object.month(), day, 0, 0, 0, 0, object.instant.getOffset());
        }, new String[0]);
        TimeTag.registerTag("next_day_of_month", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("time.next_day_of_month[...] must have input.");
                return null;
            }
            int day = attribute.getIntContext(1);
            if (day < 1 || day > 31) {
                return null;
            }
            if (object.day() >= day) {
                if (object.month() == 12) {
                    return new TimeTag(object.year() + 1, 1, day, 0, 0, 0, 0, object.instant.getOffset());
                }
                return new TimeTag(object.year(), object.month() + 1, day, 0, 0, 0, 0, object.instant.getOffset());
            }
            return new TimeTag(object.year(), object.month(), day, 0, 0, 0, 0, object.instant.getOffset());
        }, new String[0]);
        TimeTag.registerTag("start_of_year", (attribute, object) -> new TimeTag(object.year(), 1, 1, 0, 0, 0, 0, object.instant.getOffset()), new String[0]);
        TimeTag.registerTag("start_of_month", (attribute, object) -> new TimeTag(object.year(), object.month(), 1, 0, 0, 0, 0, object.instant.getOffset()), new String[0]);
        TimeTag.registerTag("start_of_day", (attribute, object) -> new TimeTag(object.year(), object.month(), object.day(), 0, 0, 0, 0, object.instant.getOffset()), new String[0]);
        TimeTag.registerTag("add", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag TimeTag.add[...] must have an input.");
                return null;
            }
            DurationTag toAdd = attribute.contextAsType(1, DurationTag.class);
            return new TimeTag(object.millis() + toAdd.getMillis(), object.instant.getZone());
        }, new String[0]);
        TimeTag.registerTag("sub", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag TimeTag.sub[...] must have an input.");
                return null;
            }
            DurationTag toSub = attribute.contextAsType(1, DurationTag.class);
            return new TimeTag(object.millis() - toSub.getMillis(), object.instant.getZone());
        }, new String[0]);
        TimeTag.registerTag("from_now", (attribute, object) -> new DurationTag((double)Math.abs(object.millis() - TimeTag.now().millis()) / 1000.0), new String[0]);
        TimeTag.registerTag("duration_since", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag TimeTag.duration_since[...] must have an input.");
                return null;
            }
            TimeTag toSub = attribute.contextAsType(1, TimeTag.class);
            return new DurationTag((double)(object.millis() - toSub.millis()) / 1000.0);
        }, new String[0]);
        TimeTag.registerTag("is_after", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag TimeTag.is_after[...] must have an input.");
                return null;
            }
            TimeTag toCompare = attribute.contextAsType(1, TimeTag.class);
            return new ElementTag(object.millis() > toCompare.millis());
        }, new String[0]);
        TimeTag.registerTag("is_before", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag TimeTag.is_before[...] must have an input.");
                return null;
            }
            TimeTag toCompare = attribute.contextAsType(1, TimeTag.class);
            return new ElementTag(object.millis() < toCompare.millis());
        }, new String[0]);
        TimeTag.registerTag("format", (attribute, object) -> new ElementTag(object.format(attribute.hasContext(1) ? attribute.getContext(1) : null)), new String[0]);
        TimeTag.registerTag("duration_compat", (attribute, object) -> {
            Deprecations.timeTagRewrite.warn(attribute.context);
            return new DurationTag((double)object.millis() / 1000.0);
        }, "in_years", "in_weeks", "in_days", "in_hours", "in_minutes", "in_seconds", "in_milliseconds", "in_ticks");
        TimeTag.registerTag("time", (attribute, object) -> {
            Deprecations.timeTagRewrite.warn(attribute.context);
            return object;
        }, new String[0]);
    }

    public String format() {
        return this.format(null);
    }

    public String format(String formatText) {
        if (formatText == null) {
            formatText = "yyyy/MM/dd HH:mm:ss";
        }
        DateTimeFormatter format = DateTimeFormatter.ofPattern(formatText);
        return this.instant.format(format);
    }

    public long millis() {
        return this.instant.toEpochSecond() * 1000L + (long)(this.instant.getNano() / 1000000);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<TimeTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("TimeTags can not hold properties.");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

