/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CastCommand
extends AbstractCommand {
    public CastCommand() {
        this.setName("cast");
        this.setSyntax("cast [<effect>] (remove) (duration:<value>) (amplifier:<#>) (<entity>|...) (no_ambient) (hide_particles) (no_icon)");
        this.setRequiredArguments(1, 8);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (PotionEffectType effect : PotionEffectType.values()) {
            addOne.accept(effect.getName());
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("remove") && arg.matches("remove", "cancel")) {
                scriptEntry.addObject("remove", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("ambient") && arg.matches("no_ambient")) {
                scriptEntry.addObject("ambient", new ElementTag(false));
                continue;
            }
            if (!scriptEntry.hasObject("show_particles") && arg.matches("hide_particles")) {
                scriptEntry.addObject("show_particles", new ElementTag(false));
                continue;
            }
            if (!scriptEntry.hasObject("show_icon") && arg.matches("no_icon")) {
                scriptEntry.addObject("show_icon", new ElementTag(false));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesPrefix("duration", "d") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("amplifier") && arg.matchesPrefix("power", "p", "amplifier", "a") && arg.matchesFloat()) {
                scriptEntry.addObject("amplifier", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("effect") && PotionEffectType.getByName((String)arg.asElement().asString()) != null) {
                scriptEntry.addObject("effect", PotionEffectType.getByName((String)arg.asElement().asString()));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            scriptEntry.defaultObject("entities", Utilities.entryDefaultEntityList(scriptEntry, true));
        }
        if (!scriptEntry.hasObject("effect")) {
            throw new InvalidArgumentsException("Must specify a valid PotionType!");
        }
        scriptEntry.defaultObject("duration", new DurationTag(60));
        scriptEntry.defaultObject("amplifier", new ElementTag(1));
        scriptEntry.defaultObject("remove", new ElementTag(false));
        scriptEntry.defaultObject("show_particles", new ElementTag(true));
        scriptEntry.defaultObject("ambient", new ElementTag(true));
        scriptEntry.defaultObject("show_icon", new ElementTag(true));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        PotionEffectType effect = (PotionEffectType)scriptEntry.getObject("effect");
        int amplifier = scriptEntry.getElement("amplifier").asInt();
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        boolean remove = scriptEntry.getElement("remove").asBoolean();
        ElementTag showParticles = scriptEntry.getElement("show_particles");
        ElementTag ambient = scriptEntry.getElement("ambient");
        ElementTag showIcon = scriptEntry.getElement("show_icon");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), ArgumentHelper.debugObj("Target(s)", entities.toString()), ArgumentHelper.debugObj("Effect", effect.getName()), ArgumentHelper.debugObj("Amplifier", amplifier), duration, ambient, showParticles, showIcon);
        }
        boolean amb = ambient.asBoolean();
        boolean showP = showParticles.asBoolean();
        boolean icon = showIcon.asBoolean();
        for (EntityTag entity : entities) {
            PotionEffect potion;
            if (entity.getLivingEntity().hasPotionEffect(effect)) {
                entity.getLivingEntity().removePotionEffect(effect);
            }
            if (remove || (potion = new PotionEffect(effect, duration.getTicksAsInt(), amplifier, amb, showP, icon)).apply(entity.getLivingEntity())) continue;
            Debug.echoError(scriptEntry.getResidingQueue(), "Bukkit was unable to apply '" + potion.getType().getName() + "' to '" + entity.toString() + "'.");
        }
    }
}

