/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.scripts.triggers.core.ChatTrigger;
import net.aufdemrand.denizen.scripts.triggers.core.ClickTrigger;
import net.aufdemrand.denizen.scripts.triggers.core.DamageTrigger;
import net.aufdemrand.denizen.scripts.triggers.core.ProximityTrigger;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.interfaces.RegistrationableInstance;
import net.aufdemrand.denizencore.interfaces.dRegistry;
import net.citizensnpcs.api.npc.NPC;

public class TriggerRegistry
implements dRegistry {
    private Map<String, AbstractTrigger> instances = new HashMap<String, AbstractTrigger>();
    private Map<Class<? extends AbstractTrigger>, String> classes = new HashMap<Class<? extends AbstractTrigger>, String>();
    Map<Integer, Map<String, Long>> npcCooldown = new ConcurrentHashMap<Integer, Map<String, Long>>(8, 0.9f, 1);
    Map<String, Map<String, Long>> playerCooldown = new ConcurrentHashMap<String, Map<String, Long>>(8, 0.9f, 1);

    @Override
    public void disableCoreMembers() {
        for (RegistrationableInstance registrationableInstance : this.instances.values()) {
            try {
                registrationableInstance.onDisable();
            }
            catch (Exception e) {
                dB.echoError("Unable to disable '" + registrationableInstance.getClass().getName() + "'!");
                dB.echoError(e);
            }
        }
    }

    @Override
    public <T extends RegistrationableInstance> T get(Class<T> clazz) {
        if (this.classes.containsKey(clazz)) {
            return (T)((RegistrationableInstance)clazz.cast(this.instances.get(this.classes.get(clazz))));
        }
        return null;
    }

    @Override
    public AbstractTrigger get(String triggerName) {
        if (this.instances.containsKey(triggerName.toUpperCase())) {
            return this.instances.get(triggerName.toUpperCase());
        }
        return null;
    }

    public Map<String, AbstractTrigger> list() {
        return this.instances;
    }

    @Override
    public boolean register(String triggerName, RegistrationableInstance instance) {
        this.instances.put(triggerName.toUpperCase(), (AbstractTrigger)instance);
        this.classes.put(((AbstractTrigger)instance).getClass(), triggerName.toUpperCase());
        return true;
    }

    @Override
    public void registerCoreMembers() {
        new ClickTrigger().activate().as("Click");
        new ChatTrigger().activate().as("Chat");
        new DamageTrigger().activate().as("Damage");
        new ProximityTrigger().activate().as("Proximity");
        dB.echoApproval("Loaded core triggers: " + this.instances.keySet().toString());
    }

    public boolean checkCooldown(NPC npc, dPlayer player, AbstractTrigger triggerClass, CooldownType cooldownType) {
        switch (cooldownType) {
            case NPC: {
                if (!this.npcCooldown.containsKey(npc.getId())) {
                    return true;
                }
                if (!this.npcCooldown.get(npc.getId()).containsKey(triggerClass.name)) {
                    return true;
                }
                if (System.currentTimeMillis() <= this.npcCooldown.get(npc.getId()).get(triggerClass.name)) break;
                return true;
            }
            case PLAYER: {
                if (!this.playerCooldown.containsKey(player.getName() + "/" + npc.getId())) {
                    return true;
                }
                if (!this.playerCooldown.get(player.getName() + "/" + npc.getId()).containsKey(triggerClass.name)) {
                    return true;
                }
                if (System.currentTimeMillis() <= this.playerCooldown.get(player.getName() + "/" + npc.getId()).get(triggerClass.name)) break;
                return true;
            }
        }
        return false;
    }

    public void setCooldown(NPC npc, dPlayer player, AbstractTrigger triggerClass, double seconds, CooldownType cooldownType) {
        Map<Object, Object> triggerMap = new HashMap<String, Long>();
        boolean noCooldown = seconds <= 0.0;
        switch (cooldownType) {
            case NPC: {
                if (this.npcCooldown.containsKey(npc.getId())) {
                    triggerMap = this.npcCooldown.get(npc.getId());
                }
                if (noCooldown && triggerMap.containsKey(triggerClass.name)) {
                    triggerMap.remove(triggerClass.name);
                } else {
                    triggerMap.put(triggerClass.name, System.currentTimeMillis() + (long)(seconds * 1000.0));
                }
                this.npcCooldown.put(npc.getId(), triggerMap);
                break;
            }
            case PLAYER: {
                if (this.playerCooldown.containsKey(player.getName() + "/" + npc.getId())) {
                    triggerMap = this.playerCooldown.get(player.getName() + "/" + npc.getId());
                }
                if (noCooldown && this.playerCooldown.containsKey(player.getName() + "/" + npc.getId())) {
                    triggerMap.remove(player.getName() + "/" + npc.getId());
                } else {
                    triggerMap.put(triggerClass.name, System.currentTimeMillis() + (long)(seconds * 1000.0));
                }
                this.playerCooldown.put(player.getName() + "/" + npc.getId(), triggerMap);
            }
        }
    }

    public static enum CooldownType {
        NPC,
        PLAYER;

    }
}

