/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags;

import com.denizenscript.denizencore.exceptions.TagProcessingException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.commands.Comparable;
import com.denizenscript.denizencore.scripts.containers.core.ProcedureScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.FutureWarning;
import java.util.HashMap;

public class ObjectTagProcessor<T extends ObjectTag> {
    public HashMap<String, TagRunnable.ObjectInterface<T, ?>> registeredObjectTags = new HashMap();

    public ObjectTagProcessor() {
        this.registerTag(ElementTag.class, "prefix", (attribute, object) -> new ElementTag(object.getPrefix()), new String[0]);
        this.registerTag(ElementTag.class, "object_type", (attribute, object) -> new ElementTag(object.getObjectType()), "type");
        this.registerTag(ObjectTag.class, "proc", (attribute, object) -> {
            ScriptQueue queue;
            ScriptTag script;
            if (!attribute.hasContext(1)) {
                return null;
            }
            String path = null;
            if (attribute.getContext(1).indexOf(46) > 0) {
                String[] split = attribute.getContext(1).split("\\.", 2);
                path = split[1];
                script = ScriptTag.valueOf(split[0], attribute.context);
            } else {
                script = attribute.contextAsType(1, ScriptTag.class);
            }
            if (script == null) {
                attribute.echoError("Missing script for procedure script tag '" + attribute.getContext(1) + "'!");
                return null;
            }
            if (!(script.getContainer() instanceof ProcedureScriptContainer)) {
                attribute.echoError("Chosen script is not a procedure script!");
                return null;
            }
            ListTag definitions = new ListTag();
            definitions.addObject(object);
            if (attribute.startsWith("context", 2) && attribute.hasContext(2)) {
                definitions.objectForms.addAll(attribute.contextAsType((int)2, ListTag.class).objectForms);
                attribute.fulfill(1);
            }
            if ((queue = ScriptUtilities.createAndStartQueue(script.getContainer(), path, attribute.context.getScriptEntryData(), null, q -> {
                q.procedural = true;
            }, null, null, definitions, script.getContainer())) == null) {
                attribute.echoError("Procedure queue start failed.");
                return null;
            }
            if (queue.determinations != null && queue.determinations.size() > 0) {
                return queue.determinations.getObject(0);
            }
            return null;
        }, new String[0]);
        this.registerTag(ObjectTag.class, "if_null", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return object;
        }, new String[0]);
        this.registerTag(ElementTag.class, "exists", (attribute, object) -> new ElementTag(true), new String[0]);
        this.registerTag(ElementTag.class, "is_truthy", (attribute, object) -> new ElementTag(object.isTruthy()), new String[0]);
        this.registerTag(ObjectTag.class, "null_if", (attribute, object) -> {
            Attribute subAttribute;
            if (!attribute.hasContext(1)) {
                return null;
            }
            String tag = attribute.getContext(1);
            boolean defaultValue = tag.endsWith("||true");
            if (defaultValue) {
                tag = tag.substring(0, tag.length() - "||true".length());
            }
            try {
                subAttribute = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            Attribute tempAttrib = new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context);
            tempAttrib.setHadAlternative(true);
            ObjectTag objs = CoreUtilities.autoAttribTyped(object, tempAttrib);
            if (objs == null ? defaultValue : CoreUtilities.equalsIgnoreCase(objs.toString(), "true")) {
                return null;
            }
            return object;
        }, new String[0]);
        this.registerTag(ObjectTag.class, "null_if_tag", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            Attribute.OverridingDefinitionProvider provider = new Attribute.OverridingDefinitionProvider(attribute.context.definitionProvider);
            provider.altDefs.putObject("null_if_value", object);
            if (CoreUtilities.equalsIgnoreCase(attribute.parseDynamicContext(1, provider).toString(), "true")) {
                return null;
            }
            return object;
        }, new String[0]);
        this.registerTag(ElementTag.class, "is", (attribute, object) -> {
            if (attribute.hasContext(1) && (attribute.startsWith("to", 2) || attribute.startsWith("than", 2)) && attribute.hasContext(2)) {
                String operator;
                boolean negative = false;
                if (attribute.getContext(1).startsWith("!")) {
                    operator = attribute.getContext(1).substring(1);
                    negative = true;
                } else {
                    operator = attribute.getContext(1);
                }
                attribute = attribute.fulfill(1);
                Comparable.Operator comparableOperator = Comparable.getOperatorFor(operator);
                if (comparableOperator == null) {
                    attribute.echoError("Unknown operator '" + operator + "'.");
                    return null;
                }
                return new ElementTag(Comparable.compare(object, attribute.getContextObject(1), comparableOperator, negative, attribute.context));
            }
            return null;
        }, new String[0]);
    }

    public void registerFutureTagDeprecation(String name, String ... deprecatedVariants) {
        TagRunnable.ObjectInterface properTag = this.registeredObjectTags.get(name);
        for (String variant : deprecatedVariants) {
            TagRunnable.ObjectInterface<ObjectTag, ObjectTag> newRunnable = (attribute, object) -> {
                if (FutureWarning.futureWarningsEnabled) {
                    Debug.echoError(attribute.context, "Using deprecated form of tag '" + name + "': '" + variant + "'.");
                }
                return properTag.run(attribute, object);
            };
            this.registeredObjectTags.put(variant, newRunnable);
        }
    }

    public <R extends ObjectTag> void registerTag(Class<R> returnType, String name, TagRunnable.ObjectInterface<T, R> runnable, String ... deprecatedVariants) {
        for (String variant : deprecatedVariants) {
            TagRunnable.ObjectInterface<ObjectTag, ObjectTag> newRunnable = (attribute, object) -> {
                Debug.echoError(attribute.context, "Using deprecated form of tag '" + name + "': '" + variant + "'.");
                return runnable.run(attribute, object);
            };
            this.registeredObjectTags.put(variant, newRunnable);
        }
        this.registeredObjectTags.put(name, runnable);
    }

    public ObjectTag getObjectAttribute(T object, Attribute attribute) {
        if (attribute == null) {
            if (Debug.verbose) {
                Debug.log("TagProcessor - Attribute null!");
            }
            return null;
        }
        attribute.lastValid = object;
        if (attribute.isComplete()) {
            if (Debug.verbose) {
                Debug.log("TagProcessor - Attribute complete! Self return!");
            }
            return object;
        }
        String attrLow = attribute.getAttributeWithoutContext(1);
        TagRunnable.ObjectInterface<T, ?> otr = this.registeredObjectTags.get(attrLow);
        if (otr != null) {
            if (Debug.verbose) {
                Debug.log("TagProcessor - Sub-tag found for " + attrLow);
            }
            attribute.seemingSuccesses.add(attrLow);
            Object returned = otr.run(attribute, object);
            if (returned == null) {
                if (Debug.verbose) {
                    Debug.log("TagProcessor - result was null");
                }
                return null;
            }
            return returned.getObjectAttribute(attribute.fulfill(1));
        }
        ObjectTag returned = CoreUtilities.autoPropertyTagObject(object, attribute);
        if (returned == null) {
            returned = object.specialTagProcessing(attribute);
        }
        if (returned != null) {
            return returned;
        }
        return object.getNextObjectTypeDown().getObjectAttribute(attribute);
    }
}

