/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;

public class EquipCommand
extends AbstractCommand {
    public EquipCommand() {
        this.setName("equip");
        this.setSyntax("equip (<entity>|...) (hand:<item>) (offhand:<item>) (head:<item>) (chest:<item>) (legs:<item>) (boots:<item>) (saddle:<item>) (horse_armor:<item>)");
        this.setRequiredArguments(1, 9);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        HashMap<String, ItemTag> equipment = new HashMap<String, ItemTag>();
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (arg.matchesArgumentType(ItemTag.class) && arg.matchesPrefix("head", "helmet")) {
                equipment.put("head", ItemTag.valueOf(arg.getValue(), scriptEntry.getContext()));
                continue;
            }
            if (arg.matchesArgumentType(ItemTag.class) && arg.matchesPrefix("chest", "chestplate")) {
                equipment.put("chest", ItemTag.valueOf(arg.getValue(), scriptEntry.getContext()));
                continue;
            }
            if (arg.matchesArgumentType(ItemTag.class) && arg.matchesPrefix("legs", "leggings")) {
                equipment.put("legs", ItemTag.valueOf(arg.getValue(), scriptEntry.getContext()));
                continue;
            }
            if (arg.matchesArgumentType(ItemTag.class) && arg.matchesPrefix("boots", "feet")) {
                equipment.put("boots", ItemTag.valueOf(arg.getValue(), scriptEntry.getContext()));
                continue;
            }
            if (arg.matchesArgumentType(ItemTag.class) && arg.matchesPrefix("saddle")) {
                equipment.put("saddle", ItemTag.valueOf(arg.getValue(), scriptEntry.getContext()));
                continue;
            }
            if (arg.matchesArgumentType(ItemTag.class) && arg.matchesPrefix("horse_armor", "horse_armour")) {
                equipment.put("horse_armor", ItemTag.valueOf(arg.getValue(), scriptEntry.getContext()));
                continue;
            }
            if (arg.matchesArgumentType(ItemTag.class) && arg.matchesPrefix("offhand")) {
                equipment.put("offhand", ItemTag.valueOf(arg.getValue(), scriptEntry.getContext()));
                continue;
            }
            if (arg.matchesArgumentType(ItemTag.class)) {
                equipment.put("hand", ItemTag.valueOf(arg.getValue(), scriptEntry.getContext()));
                continue;
            }
            if (arg.matches("player") && Utilities.entryHasPlayer(scriptEntry)) {
                scriptEntry.addObject("entities", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry).getDenizenEntity()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (equipment.isEmpty()) {
            throw new InvalidArgumentsException("Must specify equipment!");
        }
        scriptEntry.addObject("equipment", equipment);
        scriptEntry.defaultObject("entities", Utilities.entryDefaultEntityList(scriptEntry, false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Map equipment = (Map)scriptEntry.getObject("equipment");
        List entities = (List)scriptEntry.getObject("entities");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), ArgumentHelper.debugObj("entities", entities.toString()), ArgumentHelper.debugObj("equipment", equipment.toString()));
        }
        for (EntityTag entity : entities) {
            if (entity.isGeneric()) {
                Debug.echoError(scriptEntry.getResidingQueue(), "Cannot equip generic entity " + entity.identify() + "!");
                continue;
            }
            if (entity.isCitizensNPC()) {
                NPCTag npc = entity.getDenizenNPC();
                if (npc == null) continue;
                Equipment trait = npc.getEquipmentTrait();
                if (equipment.get("hand") != null) {
                    trait.set(0, ((ItemTag)equipment.get("hand")).getItemStack());
                }
                if (equipment.get("head") != null) {
                    trait.set(1, ((ItemTag)equipment.get("head")).getItemStack());
                }
                if (equipment.get("chest") != null) {
                    trait.set(2, ((ItemTag)equipment.get("chest")).getItemStack());
                }
                if (equipment.get("legs") != null) {
                    trait.set(3, ((ItemTag)equipment.get("legs")).getItemStack());
                }
                if (equipment.get("boots") != null) {
                    trait.set(4, ((ItemTag)equipment.get("boots")).getItemStack());
                }
                if (equipment.get("offhand") != null) {
                    trait.set(5, ((ItemTag)equipment.get("offhand")).getItemStack());
                }
                if (!npc.isSpawned()) continue;
                LivingEntity livingEntity = npc.getLivingEntity();
                if (livingEntity.getType() == EntityType.HORSE) {
                    if (equipment.get("saddle") != null) {
                        ((Horse)livingEntity).getInventory().setSaddle(((ItemTag)equipment.get("saddle")).getItemStack());
                    }
                    if (equipment.get("horse_armor") == null) continue;
                    ((Horse)livingEntity).getInventory().setArmor(((ItemTag)equipment.get("horse_armor")).getItemStack());
                    continue;
                }
                if (livingEntity.getType() != EntityType.PIG || equipment.get("saddle") == null) continue;
                ItemTag saddle = (ItemTag)equipment.get("saddle");
                if (saddle.getBukkitMaterial() == Material.SADDLE) {
                    ((Pig)livingEntity).setSaddle(true);
                    continue;
                }
                ((Pig)livingEntity).setSaddle(false);
                continue;
            }
            LivingEntity livingEntity = entity.getLivingEntity();
            if (livingEntity == null) continue;
            if (livingEntity.getType() == EntityType.HORSE) {
                if (equipment.get("saddle") != null) {
                    ((Horse)livingEntity).getInventory().setSaddle(((ItemTag)equipment.get("saddle")).getItemStack());
                }
                if (equipment.get("horse_armor") == null) continue;
                ((Horse)livingEntity).getInventory().setArmor(((ItemTag)equipment.get("horse_armor")).getItemStack());
                continue;
            }
            if (livingEntity.getType() == EntityType.PIG) {
                if (equipment.get("saddle") == null) continue;
                ItemTag saddle = (ItemTag)equipment.get("saddle");
                if (saddle.getBukkitMaterial() == Material.SADDLE) {
                    ((Pig)livingEntity).setSaddle(true);
                    continue;
                }
                ((Pig)livingEntity).setSaddle(false);
                continue;
            }
            if (equipment.get("hand") != null) {
                livingEntity.getEquipment().setItemInMainHand(((ItemTag)equipment.get("hand")).getItemStack());
            }
            if (equipment.get("head") != null) {
                livingEntity.getEquipment().setHelmet(((ItemTag)equipment.get("head")).getItemStack());
            }
            if (equipment.get("chest") != null) {
                livingEntity.getEquipment().setChestplate(((ItemTag)equipment.get("chest")).getItemStack());
            }
            if (equipment.get("legs") != null) {
                livingEntity.getEquipment().setLeggings(((ItemTag)equipment.get("legs")).getItemStack());
            }
            if (equipment.get("boots") != null) {
                livingEntity.getEquipment().setBoots(((ItemTag)equipment.get("boots")).getItemStack());
            }
            if (equipment.get("offhand") == null) continue;
            livingEntity.getEquipment().setItemInOffHand(((ItemTag)equipment.get("offhand")).getItemStack());
        }
    }
}

