/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EnderDragonChangePhaseEvent;

public class DragonPhaseChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static DragonPhaseChangeScriptEvent instance;
    public EntityTag entity;
    public EnderDragonChangePhaseEvent event;

    public DragonPhaseChangeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.contains("changes phase")) {
            return false;
        }
        return this.couldMatchEntity(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        if (!DragonPhaseChangeScriptEvent.tryEntity(this.entity, target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (!DragonPhaseChangeScriptEvent.runGenericSwitchCheck(path, "from", this.event.getCurrentPhase() == null ? "null" : this.event.getCurrentPhase().name())) {
            return false;
        }
        if (!DragonPhaseChangeScriptEvent.runGenericSwitchCheck(path, "to", this.event.getNewPhase().name())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "DragonPhaseChanged";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (this.exactMatchesEnum(determinationObj.toString(), (Enum<?>[])EnderDragon.Phase.values())) {
            EnderDragon.Phase phase = EnderDragon.Phase.valueOf((String)determinationObj.toString().toUpperCase());
            this.event.setNewPhase(phase);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity.getDenizenObject();
            }
            case "old_phase": {
                return new ElementTag(this.event.getCurrentPhase() == null ? "null" : this.event.getCurrentPhase().name());
            }
            case "new_phase": {
                return new ElementTag(this.event.getNewPhase().name());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEnderDragonChangePhase(EnderDragonChangePhaseEvent event) {
        this.entity = new EntityTag((Entity)event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

