/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags.core;

import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import org.bukkit.ChatColor;

public class TextTagBase {
    public TextTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                String lower = CoreUtilities.toLowerCase(event.getName());
                Attribute attribute = event.getAttributes();
                if (event.getName().equals("&auml")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag("\u00e4").getAttribute(attribute.fulfill(1)));
                } else if (event.getName().equals("&Auml")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag("\u00c4").getAttribute(attribute.fulfill(1)));
                } else if (event.getName().equals("&ouml")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag("\u00f6").getAttribute(attribute.fulfill(1)));
                } else if (event.getName().equals("&Ouml")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag("\u00d6").getAttribute(attribute.fulfill(1)));
                } else if (event.getName().equals("&uuml")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag("\u00fc").getAttribute(attribute.fulfill(1)));
                } else if (event.getName().equals("&Uuml")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag("\u00dc").getAttribute(attribute.fulfill(1)));
                } else if (lower.equals("&amp")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag("&").getAttribute(attribute.fulfill(1)));
                } else if (lower.equals("&cm")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag(",").getAttribute(attribute.fulfill(1)));
                } else if (lower.equals("&sc")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag(";").getAttribute(attribute.fulfill(1)));
                } else if (lower.equals("&pipe")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag("|").getAttribute(attribute.fulfill(1)));
                } else if (lower.equals("&ds")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag("$").getAttribute(attribute.fulfill(1)));
                } else if (lower.equals("&dot")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag(".").getAttribute(attribute.fulfill(1)));
                } else if (lower.equals("&hrt")) {
                    Deprecations.pointlessTextTags.warn(event.getScriptEntry());
                    event.setReplaced(new ElementTag("\u2665").getAttribute(attribute.fulfill(1)));
                }
            }
        }, "&auml", "&Auml", "&ouml", "&Ouml", "&uuml", "&Uuml", "&amp", "&cm", "&sc", "&pipe", "&ds", "&at", "&dot", "&hrt");
        TagManager.registerTagHandler(ElementTag.class, "empty", attribute -> new ElementTag(""));
        TagManager.registerTagHandler(ElementTag.class, "&at", attribute -> new ElementTag("@"));
        TagManager.registerTagHandler(ElementTag.class, "&pc", attribute -> new ElementTag("%"));
        TagManager.registerTagHandler(ElementTag.class, "&nl", attribute -> new ElementTag("\n"));
        TagManager.registerTagHandler(ElementTag.class, "&ss", attribute -> new ElementTag("\u00a7"));
        TagManager.registerTagHandler(ElementTag.class, "&sq", attribute -> new ElementTag("'"));
        TagManager.registerTagHandler(ElementTag.class, "&sp", attribute -> new ElementTag(String.valueOf(' ')));
        TagManager.registerTagHandler(ElementTag.class, "&nbsp", attribute -> new ElementTag(CoreUtilities.NBSP));
        TagManager.registerTagHandler(ElementTag.class, "&dq", attribute -> new ElementTag("\""));
        TagManager.registerTagHandler(ElementTag.class, "&co", attribute -> new ElementTag(":"));
        TagManager.registerTagHandler(ElementTag.class, "&rb", attribute -> new ElementTag("]"));
        TagManager.registerTagHandler(ElementTag.class, "&lb", attribute -> new ElementTag("["));
        TagManager.registerTagHandler(ElementTag.class, "&rc", attribute -> new ElementTag("}"));
        TagManager.registerTagHandler(ElementTag.class, "&lc", attribute -> new ElementTag("{"));
        TagManager.registerTagHandler(ElementTag.class, "&ns", attribute -> new ElementTag("#"));
        TagManager.registerTagHandler(ElementTag.class, "&lt", attribute -> new ElementTag("<"));
        TagManager.registerTagHandler(ElementTag.class, "&gt", attribute -> new ElementTag(">"));
        TagManager.registerTagHandler(ElementTag.class, "&bs", attribute -> new ElementTag("\\"));
        TagManager.registerTagHandler(ElementTag.class, "&chr", attribute -> new ElementTag(String.valueOf((char)Integer.parseInt(attribute.getContext(1), 16))));
        TagManager.registerTagHandler(ElementTag.class, "n", attribute -> new ElementTag("\n"));
        TagManager.registerTagHandler(ElementTag.class, "p", attribute -> new ElementTag("\n " + ChatColor.RESET + " \n"));
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String hoverText = attribute.getContext(1);
                String type = "SHOW_TEXT";
                if (attribute.startsWith("type", 2)) {
                    type = attribute.getContext(2);
                    attribute.fulfill(1);
                }
                event.setReplacedObject(new ElementTag("\u00a7[hover=" + type + ";" + FormattedTextHelper.escape(hoverText) + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&hover");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String clickText = attribute.getContext(1);
                String type = "RUN_COMMAND";
                if (attribute.startsWith("type", 2)) {
                    type = attribute.getContext(2);
                    attribute.fulfill(1);
                }
                event.setReplacedObject(new ElementTag("\u00a7[click=" + type + ";" + FormattedTextHelper.escape(clickText) + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&click");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String insertText = attribute.getContext(1);
                event.setReplacedObject(new ElementTag("\u00a7[insertion=" + FormattedTextHelper.escape(insertText) + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&insertion");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                event.setReplacedObject(new ElementTag("\u00a7[/click]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&end_click");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                event.setReplacedObject(new ElementTag("\u00a7[/hover]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&end_hover");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                event.setReplacedObject(new ElementTag("\u00a7[/insertion]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&end_insertion");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String keybindText = attribute.getContext(1);
                event.setReplacedObject(new ElementTag("\u00a7[keybind=" + FormattedTextHelper.escape(keybindText) + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&keybind");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String selectorText = attribute.getContext(1);
                event.setReplacedObject(new ElementTag("\u00a7[selector=" + FormattedTextHelper.escape(selectorText) + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&selector");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                String translateText = attribute.getContext(1);
                StringBuilder with = new StringBuilder();
                if (attribute.startsWith("with", 2)) {
                    ListTag withList = attribute.contextAsType(2, ListTag.class);
                    attribute.fulfill(1);
                    for (String str : withList) {
                        with.append(";").append(FormattedTextHelper.escape(EscapeTagBase.unEscape(str)));
                    }
                }
                event.setReplacedObject(new ElementTag("\u00a7[translate=" + FormattedTextHelper.escape(translateText) + with.toString() + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&translate");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                ListTag scoreList = attribute.contextAsType(1, ListTag.class);
                if (scoreList.size() < 2) {
                    return;
                }
                String name = FormattedTextHelper.escape(EscapeTagBase.unEscape(scoreList.get(0)));
                String objective = FormattedTextHelper.escape(EscapeTagBase.unEscape(scoreList.get(1)));
                String value = scoreList.size() >= 3 ? FormattedTextHelper.escape(EscapeTagBase.unEscape(scoreList.get(2))) : "";
                event.setReplacedObject(new ElementTag("\u00a7[score=" + name + ";" + objective + ";" + value + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&score");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Object color;
                Attribute attribute = event.getAttributes();
                if (!attribute.hasContext(1)) {
                    return;
                }
                String colorName = attribute.getContext(1);
                String colorOut = null;
                if (colorName.length() == 1) {
                    color = ChatColor.getByChar((char)colorName.charAt(0));
                    if (color != null) {
                        colorOut = color.toString();
                    }
                } else if (colorName.length() == 7 && colorName.startsWith("#")) {
                    colorOut = FormattedTextHelper.stringifyRGBSpigot(colorName.substring(1));
                } else if (colorName.startsWith("co@")) {
                    color = ColorTag.valueOf(colorName, attribute.context);
                    String hex = Integer.toHexString(((ColorTag)color).getColor().asRGB());
                    colorOut = FormattedTextHelper.stringifyRGBSpigot(hex);
                }
                if (colorOut == null) {
                    try {
                        color = ChatColor.valueOf((String)colorName.toUpperCase());
                        colorOut = color.toString();
                    }
                    catch (IllegalArgumentException ex) {
                        attribute.echoError("Color '" + colorName + "' doesn't exist (for tag &color[...]).");
                        return;
                    }
                }
                event.setReplacedObject(new ElementTag(colorOut).getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&color");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                Attribute attribute = event.getAttributes();
                if (!attribute.hasContext(1)) {
                    return;
                }
                String fontName = attribute.getContext(1);
                event.setReplacedObject(new ElementTag("\u00a7[font=" + fontName + "]").getObjectAttribute(attribute.fulfill(1)));
            }
        }, "&font");
        for (ChatColor color : ChatColor.values()) {
            String nameVal = CoreUtilities.toLowerCase(color.name());
            String retVal = color.toString();
            TagManager.registerTagHandler(ElementTag.class, nameVal, attribute -> new ElementTag(retVal));
            TagManager.registerTagHandler(ElementTag.class, "&" + color.getChar(), attribute -> new ElementTag(retVal));
        }
    }
}

