/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.CustomObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectFetcher {
    public static Map<String, ObjectType<? extends ObjectTag>> objectsByPrefix = new HashMap<String, ObjectType<? extends ObjectTag>>();
    public static Map<Class<? extends ObjectTag>, ObjectType<? extends ObjectTag>> objectsByClass = new HashMap<Class<? extends ObjectTag>, ObjectType<? extends ObjectTag>>();
    public static Map<Class<? extends ObjectTag>, List<Class<? extends ObjectTag>>> customSubtypeList = new HashMap<Class<? extends ObjectTag>, List<Class<? extends ObjectTag>>>();

    public static Collection<Class<? extends ObjectTag>> getAllApplicableSubTypesFor(Class<? extends ObjectTag> type) {
        if (type == ObjectTag.class) {
            return objectsByClass.keySet();
        }
        List<Class<? extends ObjectTag>> customSet = customSubtypeList.get(type);
        if (customSet != null) {
            return customSet;
        }
        if (type == ElementTag.class) {
            return Collections.singleton(ElementTag.class);
        }
        return Arrays.asList(type, ElementTag.class);
    }

    public static void registerCoreObjects() {
        ObjectFetcher.registerWithObjectFetcher(CustomObjectTag.class, CustomObjectTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(DurationTag.class, DurationTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(ElementTag.class, ElementTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(ListTag.class, ListTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(MapTag.class, MapTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(QueueTag.class, QueueTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(ScriptTag.class, ScriptTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(TimeTag.class, TimeTag.tagProcessor);
    }

    public static MatchesInterface getMatchesFor(Class clazz) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CallSite site = LambdaMetafactory.metafactory(lookup, "matches", MethodType.methodType(MatchesInterface.class), MethodType.methodType(Boolean.class, String.class).unwrap(), lookup.findStatic(clazz, "matches", MethodType.methodType(Boolean.class, String.class).unwrap()), MethodType.methodType(Boolean.class, String.class).unwrap());
            return site.getTarget().invoke();
        }
        catch (Throwable ex) {
            System.err.println("Failed to get matches for " + clazz.getCanonicalName());
            ex.printStackTrace();
            Debug.echoError(ex);
            return null;
        }
    }

    public static ValueOfInterface getValueOfFor(Class clazz) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CallSite site = LambdaMetafactory.metafactory(lookup, "valueOf", MethodType.methodType(ValueOfInterface.class), MethodType.methodType(ObjectTag.class, String.class, TagContext.class), lookup.findStatic(clazz, "valueOf", MethodType.methodType(clazz, String.class, TagContext.class)), MethodType.methodType(clazz, String.class, TagContext.class));
            return site.getTarget().invoke();
        }
        catch (Throwable ex) {
            System.err.println("Failed to get valueOf for " + clazz.getCanonicalName());
            ex.printStackTrace();
            Debug.echoError(ex);
            return null;
        }
    }

    @Deprecated
    public static void registerWithObjectFetcher(Class<? extends ObjectTag> objectTag) {
        ObjectFetcher.registerWithObjectFetcher(objectTag, null);
    }

    public static <T extends ObjectTag> void registerWithObjectFetcher(Class<T> objectTag, ObjectTagProcessor<T> processor) {
        ObjectType newType = new ObjectType();
        newType.clazz = objectTag;
        processor.type = objectTag;
        processor.generateCoreTags();
        newType.tagProcessor = processor;
        newType.isAdjustable = Adjustable.class.isAssignableFrom(objectTag);
        objectsByClass.put(objectTag, newType);
        try {
            Method valueOfMethod = objectTag.getMethod("valueOf", String.class, TagContext.class);
            if (valueOfMethod.isAnnotationPresent(Fetchable.class)) {
                String identifier = valueOfMethod.getAnnotation(Fetchable.class).value();
                objectsByPrefix.put(CoreUtilities.toLowerCase(identifier.trim()), newType);
                newType.prefix = identifier;
            } else {
                Debug.echoError("Type '" + objectTag.getSimpleName() + "' registered as an object type, but doesn't have a fetcher prefix.");
            }
            newType.matches = ObjectFetcher.getMatchesFor(objectTag);
            newType.valueOf = ObjectFetcher.getValueOfFor(objectTag);
            for (Method registerMethod : objectTag.getDeclaredMethods()) {
                if (!registerMethod.getName().equals("registerTags") || registerMethod.getParameterCount() != 0) continue;
                registerMethod.invoke(null, new Object[0]);
            }
        }
        catch (Throwable ex) {
            Debug.echoError("Failed to initialize an object type(" + objectTag.getSimpleName() + "): ");
            Debug.echoError(ex);
        }
    }

    public static boolean canFetch(String id) {
        return objectsByPrefix.containsKey(CoreUtilities.toLowerCase(id));
    }

    public static Class getObjectClass(String id) {
        if (ObjectFetcher.canFetch(id)) {
            return ObjectFetcher.objectsByPrefix.get((Object)CoreUtilities.toLowerCase((String)id)).clazz;
        }
        return null;
    }

    public static boolean isObjectWithProperties(String input) {
        return input.indexOf(91) != -1 && input.lastIndexOf(93) == input.length() - 1;
    }

    public static boolean checkMatch(Class<? extends ObjectTag> dClass, String value) {
        if (value == null || dClass == null) {
            return false;
        }
        int firstBracket = value.indexOf(91);
        if (firstBracket != -1 && value.lastIndexOf(93) == value.length() - 1) {
            value = value.substring(0, firstBracket);
        }
        try {
            return ObjectFetcher.objectsByClass.get(dClass).matches.matches(value);
        }
        catch (Exception e) {
            Debug.echoError(e);
            return false;
        }
    }

    public static List<String> separateProperties(String input) {
        if (!ObjectFetcher.isObjectWithProperties(input)) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>(input.length() / 7);
        int start = 0;
        boolean needObject = true;
        int brackets = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '[' && needObject) {
                needObject = false;
                output.add(input.substring(start, i));
                start = i + 1;
                continue;
            }
            if (input.charAt(i) == '[') {
                ++brackets;
                continue;
            }
            if (input.charAt(i) == ']' && brackets > 0) {
                --brackets;
                continue;
            }
            if (input.charAt(i) != ';' && input.charAt(i) != ']' || brackets != 0) continue;
            output.add(input.substring(start, i));
            start = i + 1;
        }
        return output;
    }

    public static <T extends ObjectTag> T getObjectFrom(Class<T> dClass, String value, TagContext context) {
        return (T)ObjectFetcher.getObjectFrom(objectsByClass.get(dClass), value, context);
    }

    public static <T extends ObjectTag> T getObjectFromWithProperties(Class<T> dClass, String value, TagContext context) {
        return (T)ObjectFetcher.getObjectFromWithProperties(objectsByClass.get(dClass), value, context);
    }

    public static String partialUnescape(String description) {
        if (description.indexOf(38) != -1) {
            description = CoreUtilities.replace(description, "&sc", ";");
            description = CoreUtilities.replace(description, "&lb", "[");
            description = CoreUtilities.replace(description, "&rb", "]");
            description = CoreUtilities.replace(description, "&eq", "=");
            description = CoreUtilities.replace(description, "&amp", "&");
        }
        return description;
    }

    public static String unescapeProperty(String description) {
        if (description.indexOf(38) == -1) {
            return description;
        }
        int openBracket = description.indexOf(91);
        if (openBracket == -1) {
            return ObjectFetcher.partialUnescape(description);
        }
        int length = description.length();
        StringBuilder result = new StringBuilder(length);
        int start = 0;
        int brackets = 0;
        for (int i = openBracket; i < length; ++i) {
            char c = description.charAt(i);
            if (c == '[') {
                if (++brackets != 1) continue;
                result.append(ObjectFetcher.partialUnescape(description.substring(start, i)));
                start = i;
                continue;
            }
            if (c != ']' || --brackets != 0) continue;
            result.append(description, start, i);
            start = i;
            i = description.indexOf(91, start) - 1;
            if (i < 0) break;
        }
        result.append(ObjectFetcher.partialUnescape(description.substring(start)));
        return result.toString();
    }

    public static void applyPropertySet(Adjustable object, TagContext context, List<String> properties) {
        for (int i = 1; i < properties.size(); ++i) {
            List<String> data = CoreUtilities.split(properties.get(i), '=', 2);
            if (data.size() != 2) {
                Debug.echoError("Invalid property string '" + properties.get(i) + "'!");
                continue;
            }
            String description = ObjectFetcher.unescapeProperty(data.get(1));
            object.safeApplyProperty(new Mechanism(data.get(0), new ElementTag(description), context));
        }
    }

    public static <T extends ObjectTag> T getObjectFrom(ObjectType<T> type, String value, TagContext context) {
        try {
            return type.valueOf.valueOf(value, context);
        }
        catch (Exception e) {
            Debug.echoError(e);
            return null;
        }
    }

    public static <T extends ObjectTag> T getObjectFromWithProperties(ObjectType<T> type, String value, TagContext context) {
        try {
            List<String> matches = ObjectFetcher.separateProperties(value);
            boolean matched = matches != null && type.isAdjustable;
            Object gotten = type.valueOf.valueOf(matched ? matches.get(0) : value, context);
            if (gotten != null && matched) {
                ObjectFetcher.applyPropertySet((Adjustable)gotten, context, matches);
                gotten = gotten.fixAfterProperties();
            }
            return gotten;
        }
        catch (Exception e) {
            Debug.echoError(e);
            return null;
        }
    }

    public static ObjectTag pickObjectFor(String value, TagContext context) {
        ObjectTag fetched;
        String type;
        ObjectType<? extends ObjectTag> toFetch;
        if (value == null) {
            return null;
        }
        if (CoreUtilities.contains(value, '@') && (toFetch = objectsByPrefix.get(type = value.split("@", 2)[0])) != null && (fetched = ObjectFetcher.getObjectFrom(toFetch, value, context)) != null) {
            return fetched;
        }
        return new ElementTag(value);
    }

    public static class ObjectType<T extends ObjectTag> {
        public Class<T> clazz;
        public MatchesInterface matches;
        public ValueOfInterface<T> valueOf;
        public ObjectTagProcessor<T> tagProcessor;
        public String prefix;
        public boolean isAdjustable;
    }

    public static interface ValueOfInterface<T extends ObjectTag> {
        public T valueOf(String var1, TagContext var2);
    }

    @FunctionalInterface
    public static interface MatchesInterface {
        public boolean matches(String var1);
    }
}

