/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;

public class EngageCommand
extends AbstractCommand {
    private static Map<NPC, Long> currentlyEngaged = new HashMap<NPC, Long>();

    public EngageCommand() {
        this.setName("engage");
        this.setSyntax("engage (<duration>)");
        this.setRequiredArguments(0, 1);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("duration", new DurationTag(0));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        NPCTag npc = Utilities.getEntryNPC(scriptEntry);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), npc.debug() + duration.debug());
        }
        if (duration.getSecondsAsInt() > 0) {
            EngageCommand.setEngaged(npc.getCitizen(), duration.getSecondsAsInt());
        } else {
            EngageCommand.setEngaged(npc.getCitizen(), true);
        }
    }

    public static boolean getEngaged(NPC npc) {
        return currentlyEngaged.containsKey(npc) && currentlyEngaged.get(npc) > System.currentTimeMillis();
    }

    public static void setEngaged(NPC npc, boolean engaged) {
        if (engaged) {
            currentlyEngaged.put(npc, System.currentTimeMillis() + (long)DurationTag.valueOf(Settings.engageTimeoutInSeconds(), CoreUtilities.basicContext).getSeconds() * 1000L);
        }
        if (!engaged) {
            currentlyEngaged.remove(npc);
        }
    }

    public static void setEngaged(NPC npc, int duration) {
        currentlyEngaged.put(npc, System.currentTimeMillis() + (long)(duration * 1000));
    }
}

