/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialSwitchable;
import com.denizenscript.denizen.scripts.commands.world.AdjustBlockCommand;
import com.denizenscript.denizen.scripts.commands.world.ModifyBlockCommand;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.plugin.Plugin;

public class SwitchCommand
extends AbstractCommand {
    private Map<Location, Integer> taskMap = new HashMap<Location, Integer>(32);

    public SwitchCommand() {
        this.setName("switch");
        this.setSyntax("switch [<location>|...] (state:[{toggle}/on/off]) (duration:<value>) (no_physics)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (Notable note : NoteManager.notesByType.get(LocationTag.class)) {
            addOne.accept(NoteManager.getSavedId(note));
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("no_physics") && arg.matches("no_physics")) {
                scriptEntry.addObject("no_physics", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("locations") && arg.matchesArgumentList(LocationTag.class)) {
                scriptEntry.addObject("locations", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("state") && arg.matchesEnum(SwitchState.values())) {
                scriptEntry.addObject("switchstate", new ElementTag(arg.getValue().toUpperCase()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("locations")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        scriptEntry.defaultObject("duration", new DurationTag(0));
        scriptEntry.defaultObject("switchstate", new ElementTag("TOGGLE"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ListTag interactLocations = (ListTag)scriptEntry.getObjectTag("locations");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        SwitchState switchState = SwitchState.valueOf(scriptEntry.getElement("switchstate").asString());
        ElementTag noPhysics = scriptEntry.getElement("no_physics");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), interactLocations, duration, noPhysics, ArgumentHelper.debugObj("switchstate", switchState.name()));
        }
        boolean physics = noPhysics == null || !noPhysics.asBoolean();
        for (LocationTag interactLocation : interactLocations.filter(LocationTag.class, scriptEntry)) {
            this.switchBlock(scriptEntry, interactLocation, switchState, physics);
            if (duration.getTicks() <= 0L) continue;
            if (this.taskMap.containsKey(interactLocation)) {
                try {
                    Bukkit.getScheduler().cancelTask(this.taskMap.get(interactLocation).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Debug.echoDebug((Debuggable)scriptEntry, "Setting delayed task 'SWITCH' for " + interactLocation.identify());
            this.taskMap.put(interactLocation, Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> this.switchBlock(scriptEntry, interactLocation, SwitchState.TOGGLE, physics), duration.getTicks()));
        }
    }

    public static boolean switchState(Block b) {
        MaterialSwitchable switchable = MaterialSwitchable.getFrom(new MaterialTag(b.getBlockData()));
        if (switchable == null) {
            return false;
        }
        return switchable.getState();
    }

    public void switchBlock(ScriptEntry scriptEntry, Location interactLocation, SwitchState switchState, boolean physics) {
        Block block = interactLocation.getBlock();
        BlockData data1 = block.getBlockData();
        MaterialTag materialTag = new MaterialTag(data1);
        MaterialSwitchable switchable = MaterialSwitchable.getFrom(materialTag);
        if (switchable == null) {
            Debug.echoError("Cannot switch block of type '" + materialTag.getMaterial().name() + "'");
            return;
        }
        boolean currentState = switchable.getState();
        if (switchState.equals((Object)SwitchState.ON) && !currentState || switchState.equals((Object)SwitchState.OFF) && currentState || switchState.equals((Object)SwitchState.TOGGLE)) {
            switchable.setState(!currentState);
            if (physics) {
                block.setBlockData(switchable.material.getModernData());
            } else {
                ModifyBlockCommand.setBlock(block.getLocation(), materialTag, false, null);
            }
            if (data1 instanceof Bisected && !(data1 instanceof TrapDoor)) {
                Location other = interactLocation.clone();
                other = ((Bisected)data1).getHalf() == Bisected.Half.TOP ? other.add(0.0, -1.0, 0.0) : other.add(0.0, 1.0, 0.0);
                BlockData data2 = other.getBlock().getBlockData();
                if (data2.getMaterial() == data1.getMaterial()) {
                    MaterialSwitchable switchable2 = MaterialSwitchable.getFrom(new MaterialTag(data2));
                    switchable2.setState(!currentState);
                    other.getBlock().setBlockData(switchable2.material.getModernData());
                    if (physics) {
                        AdjustBlockCommand.applyPhysicsAt(other);
                    }
                }
            }
            if (physics) {
                AdjustBlockCommand.applyPhysicsAt(interactLocation);
            }
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Switched " + block.getType().toString() + "! Current state now: " + (SwitchCommand.switchState(block) ? "ON" : "OFF"));
            }
        }
    }

    private static enum SwitchState {
        ON,
        OFF,
        TOGGLE;

    }
}

