/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;

public class ClickableCommand
extends AbstractCommand {
    public static HashMap<UUID, Clickable> clickables = new HashMap();

    public ClickableCommand() {
        this.setName("clickable");
        this.setSyntax("clickable [<script>] (def:<element>|.../defmap:<map>/def.<name>:<value>) (usages:<#>) (for:<player>|...) (until:<duration>)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (ScriptContainer script : ScriptRegistry.scriptContainers.values()) {
            if (!(script instanceof TaskScriptContainer)) continue;
            addOne.accept(script.getName());
        }
    }

    public static void runClickable(UUID id, Player player) {
        Clickable clickable = clickables.get(id);
        if (clickable == null) {
            return;
        }
        if (clickable.until != 0L && System.currentTimeMillis() > clickable.until) {
            clickables.remove(id);
            return;
        }
        if (clickable.forPlayers != null && !clickable.forPlayers.contains(player.getUniqueId())) {
            return;
        }
        if (clickable.remainingUsages > 0) {
            --clickable.remainingUsages;
            if (clickable.remainingUsages <= 0) {
                clickables.remove(id);
            }
        }
        Consumer<ScriptQueue> configure = queue -> {
            if (clickable.defMap != null) {
                for (Map.Entry<StringHolder, ObjectTag> val : clickable.defMap.map.entrySet()) {
                    queue.addDefinition(val.getKey().str, val.getValue());
                }
            }
        };
        ScriptUtilities.createAndStartQueue(clickable.script.getContainer(), clickable.path, new BukkitScriptEntryData(new PlayerTag(player), clickable.npc), null, configure, null, null, clickable.definitions, clickable.context);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        MapTag defMap = new MapTag();
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("definitions") && arg.matchesPrefix("def")) {
                scriptEntry.addObject("definitions", arg.asType(ListTag.class));
                continue;
            }
            if (arg.matchesPrefix("defmap") && arg.matchesArgumentType(MapTag.class)) {
                defMap.map.putAll(arg.asType(MapTag.class).map);
                continue;
            }
            if (!scriptEntry.hasObject("usages") && arg.matchesPrefix("usages") && arg.matchesInteger()) {
                scriptEntry.addObject("usages", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("until") && arg.matchesPrefix("until") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("until", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("for_players") && arg.matchesPrefix("for") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("for_players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (arg.hasPrefix() && arg.getPrefix().getRawValue().startsWith("def.")) {
                defMap.putObject(arg.getPrefix().getRawValue().substring("def.".length()), arg.object);
                continue;
            }
            if (!scriptEntry.hasObject("script")) {
                ScriptTag script;
                String scriptName = arg.getRawValue();
                int dotIndex = scriptName.indexOf(46);
                if (dotIndex > 0) {
                    scriptEntry.addObject("path", new ElementTag(scriptName.substring(dotIndex + 1)));
                    scriptName = scriptName.substring(0, dotIndex);
                }
                if (!(script = new ScriptTag(scriptName)).isValid()) {
                    arg.reportUnhandled();
                    continue;
                }
                scriptEntry.addObject("script", script);
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Missing script argument!");
        }
        if (!defMap.map.isEmpty()) {
            scriptEntry.addObject("def_map", defMap);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        ElementTag path = scriptEntry.getElement("path");
        List forPlayers = (List)scriptEntry.getObject("for_players");
        ElementTag usages = scriptEntry.getElement("usages");
        ListTag definitions = (ListTag)scriptEntry.getObjectTag("definitions");
        DurationTag until = (DurationTag)scriptEntry.getObjectTag("until");
        MapTag defMap = (MapTag)scriptEntry.getObjectTag("def_map");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), script, path, usages, definitions, defMap, until, forPlayers == null ? "" : ArgumentHelper.debugList("for", forPlayers));
        }
        UUID id = UUID.randomUUID();
        Clickable newClickable = new Clickable();
        newClickable.script = script;
        newClickable.path = path == null ? null : path.asString();
        newClickable.definitions = definitions;
        newClickable.remainingUsages = usages == null ? -1 : usages.asInt();
        newClickable.until = until == null ? 0L : System.currentTimeMillis() + until.getMillis();
        newClickable.context = scriptEntry.context;
        newClickable.npc = Utilities.getEntryNPC(scriptEntry);
        newClickable.defMap = defMap;
        if (forPlayers != null) {
            newClickable.forPlayers = new HashSet(forPlayers.size());
            for (PlayerTag player : forPlayers) {
                newClickable.forPlayers.add(player.getUUID());
            }
        }
        clickables.put(id, newClickable);
        scriptEntry.addObject("command", new ElementTag("/denizenclickable " + id));
    }

    public static class Clickable {
        public HashSet<UUID> forPlayers;
        public ListTag definitions;
        public MapTag defMap;
        public ScriptTag script;
        public String path;
        public NPCTag npc;
        public int remainingUsages;
        public TagContext context;
        public long until;
    }
}

