/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.flags.LocationFlagSearchHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.function.Predicate;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public interface AreaContainmentObject
extends ObjectTag {
    public String getNoteName();

    public boolean doesContainLocation(Location var1);

    public CuboidTag getCuboidBoundary();

    public WorldTag getWorld();

    public ListTag getShell();

    public ListTag getBlocks(Predicate<Location> var1);

    public AreaContainmentObject withWorld(WorldTag var1);

    default public ListTag getBlocksFlagged(String flagName, Attribute attribute) {
        CuboidTag cuboid = this.getCuboidBoundary();
        ListTag blocks = new ListTag();
        for (CuboidTag.LocationPair pair : cuboid.pairs) {
            ChunkTag minChunk = new ChunkTag(pair.low);
            ChunkTag maxChunk = new ChunkTag(pair.high);
            ChunkTag subChunk = new ChunkTag(pair.low);
            for (int x = minChunk.getX(); x <= maxChunk.getX(); ++x) {
                subChunk.chunkX = x;
                for (int z = minChunk.getZ(); z <= maxChunk.getZ(); ++z) {
                    subChunk.chunkZ = z;
                    subChunk.cachedChunk = null;
                    if (!subChunk.isLoadedSafe()) continue;
                    LocationFlagSearchHelper.getFlaggedLocations(subChunk.getChunkForTag(attribute), flagName, loc -> {
                        if (this.doesContainLocation((Location)loc)) {
                            blocks.addObject(new LocationTag((Location)loc));
                        }
                    });
                }
            }
        }
        return blocks;
    }

    public static <T extends AreaContainmentObject> void registerTags(Class<T> type, ObjectTagProcessor<T> processor) {
        processor.registerTag(CuboidTag.class, "bounding_box", (attribute, area) -> area.getCuboidBoundary(), new String[0]);
        processor.registerTag(WorldTag.class, "world", (attribute, area) -> area.getWorld(), new String[0]);
        processor.registerTag(ListTag.class, "players", (attribute, area) -> {
            ListTag result = new ListTag();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!area.doesContainLocation(player.getLocation())) continue;
                result.addObject(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
            }
            return result;
        }, new String[0]);
        if (Depends.citizens != null) {
            processor.registerTag(ListTag.class, "npcs", (attribute, area) -> {
                ListTag result = new ListTag();
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    NPCTag dnpc = new NPCTag(npc);
                    if (!area.doesContainLocation(dnpc.getLocation())) continue;
                    result.addObject(dnpc);
                }
                return result;
            }, new String[0]);
        }
        processor.registerTag(ListTag.class, "entities", (attribute, area) -> {
            String matcher = attribute.hasContext(1) ? attribute.getContext(1) : null;
            ListTag entities = new ListTag();
            for (Entity ent : area.getCuboidBoundary().getEntitiesPossiblyWithinForTag()) {
                if (!area.doesContainLocation(ent.getLocation())) continue;
                EntityTag current = new EntityTag(ent);
                if (matcher != null && !BukkitScriptEvent.tryEntity(current, matcher)) continue;
                entities.addObject(current.getDenizenObject());
            }
            return entities;
        }, new String[0]);
        processor.registerTag(ListTag.class, "living_entities", (attribute, area) -> {
            ListTag result = new ListTag();
            for (Entity ent : area.getCuboidBoundary().getEntitiesPossiblyWithinForTag()) {
                if (!(ent instanceof LivingEntity) || !area.doesContainLocation(ent.getLocation()) || EntityTag.isCitizensNPC(ent)) continue;
                result.addObject(new EntityTag(ent).getDenizenObject());
            }
            return result;
        }, new String[0]);
        processor.registerTag(ElementTag.class, "contains", (attribute, area) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            LocationTag loc = attribute.contextAsType(1, LocationTag.class);
            if (loc == null) {
                return null;
            }
            return new ElementTag(area.doesContainLocation(loc));
        }, "contains_location");
        processor.registerTag(ListTag.class, "blocks", (attribute, area) -> {
            if (attribute.hasContext(1)) {
                NMSHandler.getChunkHelper().changeChunkServerThread(area.getWorld().getWorld());
                try {
                    String matcher = attribute.getContext(1);
                    Predicate<Location> predicate = l -> BukkitScriptEvent.tryMaterial(l.getBlock().getType(), matcher);
                    ListTag listTag = area.getBlocks(predicate);
                    return listTag;
                }
                finally {
                    NMSHandler.getChunkHelper().restoreServerThread(area.getWorld().getWorld());
                }
            }
            return area.getBlocks(null);
        }, "get_blocks");
        processor.registerTag(ListTag.class, "spawnable_blocks", (attribute, area) -> {
            NMSHandler.getChunkHelper().changeChunkServerThread(area.getWorld().getWorld());
            try {
                if (attribute.hasContext(1)) {
                    String matcher = attribute.getContext(1);
                    Predicate<Location> predicate = l -> AreaContainmentObject.isSpawnable(l) && BukkitScriptEvent.tryMaterial(l.getBlock().getRelative(0, -1, 0).getType(), matcher);
                    ListTag listTag = area.getBlocks(predicate);
                    return listTag;
                }
                ListTag listTag = area.getBlocks(AreaContainmentObject::isSpawnable);
                return listTag;
            }
            finally {
                NMSHandler.getChunkHelper().restoreServerThread(area.getWorld().getWorld());
            }
        }, "get_spawnable_blocks");
        processor.registerTag(ListTag.class, "blocks_flagged", (attribute, area) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return area.getBlocksFlagged(CoreUtilities.toLowerCase(attribute.getContext(1)), attribute);
        }, new String[0]);
        processor.registerTag(ListTag.class, "shell", (attribute, area) -> area.getShell(), new String[0]);
        processor.registerTag(ElementTag.class, "is_within", (attribute, area) -> {
            CuboidTag cuboid;
            if (!attribute.hasContext(1)) {
                return null;
            }
            CuboidTag cub2 = attribute.contextAsType(1, CuboidTag.class);
            if (cub2 == null) {
                return null;
            }
            CuboidTag cuboidTag = cuboid = area instanceof CuboidTag ? (CuboidTag)area : area.getCuboidBoundary();
            if (cub2 != null) {
                boolean contains = true;
                for (CuboidTag.LocationPair pair2 : cuboid.pairs) {
                    boolean contained = false;
                    for (CuboidTag.LocationPair pair : cub2.pairs) {
                        if (!pair.low.getWorld().getName().equalsIgnoreCase(pair2.low.getWorld().getName())) {
                            return new ElementTag(false);
                        }
                        if (!(pair2.low.getX() >= pair.low.getX()) || !(pair2.low.getY() >= pair.low.getY()) || !(pair2.low.getZ() >= pair.low.getZ()) || !(pair2.high.getX() <= pair.high.getX()) || !(pair2.high.getY() <= pair.high.getY()) || !(pair2.high.getZ() <= pair.high.getZ())) continue;
                        contained = true;
                        break;
                    }
                    if (contained) continue;
                    contains = false;
                    break;
                }
                return new ElementTag(contains);
            }
            return null;
        }, new String[0]);
        processor.registerTag(type, "with_world", (attribute, area) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            WorldTag world = attribute.contextAsType(1, WorldTag.class);
            if (world == null) {
                return null;
            }
            return area.withWorld(world);
        }, new String[0]);
    }

    public static boolean isSpawnable(Location loc) {
        return loc.getBlock().getType().isAir() && loc.clone().add(0.0, 1.0, 0.0).getBlock().getType().isAir() && loc.clone().add(0.0, -1.0, 0.0).getBlock().getType().isSolid();
    }
}

