/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.midi.MidiUtil;
import com.denizenscript.denizen.utilities.midi.NoteBlockReceiver;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.io.File;
import java.util.List;

public class MidiCommand
extends AbstractCommand
implements Holdable {
    public MidiCommand() {
        this.setName("midi");
        this.setSyntax("midi [cancel/<file> (tempo:<#.#>) (volume:<#.#>)] (<location>/<entity>|...)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("cancel") && (arg.matches("cancel") || arg.matches("stop"))) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("volume") && arg.matchesFloat() && arg.matchesPrefix("volume", "vol", "v")) {
                scriptEntry.addObject("volume", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("tempo") && arg.matchesFloat()) {
                scriptEntry.addObject("tempo", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("file")) {
                String path = Denizen.getInstance().getDataFolder() + File.separator + "midi" + File.separator + arg.getValue();
                if (!path.endsWith(".mid")) {
                    path = path + ".mid";
                }
                scriptEntry.addObject("file", new ElementTag(path));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("file") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Missing file (Midi name) argument!");
        }
        if (!scriptEntry.hasObject("location")) {
            scriptEntry.defaultObject("entities", Utilities.entryDefaultEntityList(scriptEntry, true));
        }
        scriptEntry.defaultObject("tempo", new ElementTag(1)).defaultObject("volume", new ElementTag(10));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        File file;
        boolean cancel = scriptEntry.hasObject("cancel");
        File file2 = file = !cancel ? new File(scriptEntry.getElement("file").asString()) : null;
        if (!cancel && !Utilities.canReadFile(file)) {
            Debug.echoError("Cannot read from that file path due to security settings in Denizen/config.yml.");
            return;
        }
        if (!cancel && !file.exists()) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Invalid file " + scriptEntry.getElement("file").asString());
            return;
        }
        List entities = (List)scriptEntry.getObject("entities");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        float tempo = scriptEntry.getElement("tempo").asFloat();
        float volume = scriptEntry.getElement("volume").asFloat();
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), (cancel ? ArgumentHelper.debugObj("cancel", cancel) : "") + (file != null ? ArgumentHelper.debugObj("file", file.getPath()) : "") + (entities != null ? ArgumentHelper.debugObj("entities", entities.toString()) : "") + (location != null ? location.debug() : "") + ArgumentHelper.debugObj("tempo", Float.valueOf(tempo)) + ArgumentHelper.debugObj("volume", Float.valueOf(volume)));
        }
        if (!cancel) {
            NoteBlockReceiver rec = location != null ? MidiUtil.playMidi(file, tempo, volume, location) : MidiUtil.playMidi(file, tempo, volume, entities);
            if (rec == null) {
                Debug.echoError(scriptEntry.getResidingQueue(), "Something went wrong playing a midi!");
                scriptEntry.setFinished(true);
            } else {
                rec.onFinish = () -> scriptEntry.setFinished(true);
            }
        } else {
            if (location != null) {
                MidiUtil.stopMidi(location.identify());
            } else {
                MidiUtil.stopMidi(entities);
            }
            scriptEntry.setFinished(true);
        }
    }
}

