/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags;

import com.denizenscript.denizencore.exceptions.TagProcessingException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.DefinitionProvider;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Attribute {
    private static HashMap<String, AttributeComponent[]> attribsLookup = new HashMap();
    public AttributeComponent[] attributes;
    public ObjectTag[] contexts;
    public Boolean[] filled;
    ScriptEntry scriptEntry;
    public TagContext context;
    String origin;
    public ArrayList<String> seemingSuccesses = new ArrayList(2);
    public boolean hadManualFulfill = false;
    public ObjectTag lastValid;
    public boolean hasContextFailed = false;
    int fulfilled = 0;
    private boolean hadAlternative = false;
    public static final HashMap<String, TagManager.TagBaseData> fallbackTags = new HashMap();

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static AttributeComponent[] separate_attributes(String attributes) throws TagProcessingException {
        AttributeComponent[] matchesRes = attribsLookup.get(attributes);
        if (matchesRes != null) {
            return matchesRes;
        }
        if (attributes.startsWith(".") || attributes.endsWith(".")) {
            throw new TagProcessingException("The tag '" + attributes + "' is invalid due to a misplaced dot at the start or end of the tag.");
        }
        ObjectTagProcessor<? extends ObjectTag> proc = null;
        ArrayList<AttributeComponent> matches = new ArrayList<AttributeComponent>(attributes.length() / 7);
        int x1 = 0;
        int x2 = -1;
        int braced = 0;
        char[] attrInp = attributes.toCharArray();
        for (int x = 0; x < attrInp.length; ++x) {
            char chr = attrInp[x];
            if (chr == '[') {
                ++braced;
            }
            if (x == attrInp.length - 1) {
                x2 = x + 1;
            }
            if (chr == ']') {
                if (braced > 0) {
                    --braced;
                }
            } else if (!(chr != '.' || x > 0 && Attribute.isNumber(attrInp[x + 1]) && Attribute.isNumber(attrInp[x - 1]) || braced != 0)) {
                x2 = x;
            }
            if (x2 <= -1) continue;
            if (x2 <= x1) {
                throw new TagProcessingException("The tag '" + attributes + "' is invalid, likely due to double dots '..' somewhere. Did you forget a sub-tag, or accidentally double-tap the dot key?");
            }
            AttributeComponent component = new AttributeComponent(attributes.substring(x1, x2));
            if (matches.size() == 0) {
                TagManager.TagBaseData baseTag = TagManager.baseTags.get(component.key);
                if (baseTag != null && baseTag.processor != null) {
                    proc = baseTag.processor;
                }
            } else if (proc != null) {
                component.data = proc.registeredObjectTags.get(component.key);
                proc = component.data == null ? null : component.data.processor;
            }
            matches.add(component);
            x2 = -1;
            x1 = x + 1;
        }
        if (braced != 0) {
            throw new TagProcessingException("The tag '" + attributes + "' is invalid due to misplaced [square brackets]. Did you forget to close some brackets?");
        }
        if (Debug.verbose) {
            Debug.log("attribute splitter: '" + attributes + "' becomes: " + matches);
        }
        matchesRes = new AttributeComponent[matches.size()];
        matchesRes = matches.toArray(matchesRes);
        attribsLookup.put(attributes, matchesRes);
        return matchesRes;
    }

    public void resetErrorTrack() {
        if (Debug.verbose) {
            Debug.echoError("(Verbose) Attribute - error track reset");
        }
        if (!this.seemingSuccesses.isEmpty()) {
            this.seemingSuccesses.clear();
        }
        this.hasContextFailed = false;
    }

    public ScriptEntry getScriptEntry() {
        return this.scriptEntry;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Attribute(Attribute ref, ScriptEntry scriptEntry, TagContext context) {
        this.origin = ref.origin;
        this.scriptEntry = scriptEntry;
        this.context = context;
        this.attributes = ref.attributes;
        this.contexts = new ObjectTag[this.attributes.length];
        this.setHadAlternative(ref.hadAlternative);
        if (context == null || context.debug) {
            this.filled = new Boolean[this.attributes.length];
        }
    }

    public Attribute(String attributes, ScriptEntry scriptEntry, TagContext context) throws TagProcessingException {
        this.origin = attributes;
        this.scriptEntry = scriptEntry;
        this.context = context;
        this.attributes = Attribute.separate_attributes(attributes);
        this.contexts = new ObjectTag[this.attributes.length];
        if (context == null || context.debug) {
            this.filled = new Boolean[this.attributes.length];
        }
    }

    public boolean matches(String string) {
        if (this.fulfilled >= this.attributes.length) {
            return false;
        }
        return this.attributes[this.fulfilled].key.equals(string);
    }

    public boolean startsWith(String string) {
        if (this.fulfilled >= this.attributes.length) {
            return false;
        }
        if (Debug.verbose) {
            Debug.log("Trying tag startsWith " + string + " on tag " + this.toString());
        }
        if (string.indexOf(46) >= 0) {
            List<String> tmp = CoreUtilities.split(string, '.');
            if (tmp.size() + this.fulfilled > this.attributes.length) {
                return false;
            }
            for (int i = 0; i < tmp.size(); ++i) {
                if (this.attributes[this.fulfilled + i].key.equals(tmp.get(i))) continue;
                return false;
            }
            if (Debug.verbose) {
                Debug.log("Chain-Tag found!");
            }
            this.seemingSuccesses.add(string);
            return true;
        }
        if (this.attributes[this.fulfilled].key.equals(string)) {
            if (Debug.verbose) {
                Debug.log("Sub-tag found!");
            }
            this.seemingSuccesses.add(string);
            return true;
        }
        return false;
    }

    public boolean startsWith(String string, int attribute) {
        return CoreUtilities.toLowerCase(this.getAttributeWithoutContext(attribute)).equals(string);
    }

    public boolean isComplete() {
        return this.fulfilled >= this.attributes.length;
    }

    public Attribute fulfill(int attributes) {
        this.hadManualFulfill = true;
        this.resetErrorTrack();
        if (this.filled != null) {
            for (int i = 0; i < attributes; ++i) {
                if (this.fulfilled + i >= this.filled.length) continue;
                this.filled[this.fulfilled + i] = Boolean.TRUE;
            }
        }
        this.fulfilled += attributes;
        return this;
    }

    public final void fulfillOne(ObjectTag obj) {
        this.lastValid = obj;
        this.resetErrorTrack();
        if (this.filled != null && this.fulfilled < this.filled.length) {
            this.filled[this.fulfilled] = Boolean.TRUE;
        }
        ++this.fulfilled;
    }

    public final void trackLastTagFailure() {
        if (this.fulfilled < this.attributes.length) {
            this.seemingSuccesses.add(this.attributes[this.fulfilled].key);
            if (this.filled != null) {
                this.filled[this.fulfilled] = Boolean.FALSE;
            }
        }
    }

    public boolean hasContext(int attribute) {
        if ((attribute += this.fulfilled - 1) < 0 || attribute >= this.attributes.length) {
            return false;
        }
        if (this.attributes[attribute].context != null) {
            return true;
        }
        if (Debug.verbose) {
            Debug.log("Attribute " + attribute + " is missing context, hasContextFailed");
        }
        this.hasContextFailed = true;
        return false;
    }

    public String getRawContext(int attribute) {
        if ((attribute += this.fulfilled - 1) < 0 || attribute >= this.attributes.length) {
            return null;
        }
        return this.attributes[attribute].context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectTag parseDynamicContext(int attribute, OverridingDefinitionProvider customProvider) {
        String inp = this.getRawContext(attribute);
        if (inp == null) {
            return null;
        }
        DefinitionProvider originalProvider = this.context.definitionProvider;
        this.context.definitionProvider = customProvider;
        try {
            ObjectTag objectTag = TagManager.tagObject(inp, this.context);
            return objectTag;
        }
        finally {
            this.context.definitionProvider = originalProvider;
        }
    }

    public <T extends ObjectTag> T contextAsType(int attribute, Class<T> dClass) {
        ObjectTag contextObj = this.getContextObject(attribute);
        if (contextObj == null) {
            return null;
        }
        return CoreUtilities.asType(contextObj, dClass, this.context);
    }

    public ObjectTag getContextObject(int attribute) {
        if ((attribute += this.fulfilled - 1) < 0 || attribute >= this.attributes.length) {
            return null;
        }
        ObjectTag tagged = this.contexts[attribute];
        if (tagged != null) {
            return tagged;
        }
        AttributeComponent component = this.attributes[attribute];
        if (component.contextParsed == null) {
            String inp = this.attributes[attribute].context;
            if (inp == null) {
                return null;
            }
            component.contextParsed = TagManager.parseTextToTag(component.context, this.context);
        }
        if (component.contextParsed == null) {
            return null;
        }
        this.contexts[attribute] = tagged = component.contextParsed.parse(this.context);
        return tagged;
    }

    public String getContext(int attribute) {
        return CoreUtilities.stringifyNullPass(this.getContextObject(attribute));
    }

    public boolean hasAlternative() {
        if (this.hadAlternative) {
            return true;
        }
        return this.getFallbackTagIndex() != -1;
    }

    public int getFallbackTagIndex() {
        for (int i = this.fulfilled + 1; i < this.attributes.length; ++i) {
            if (!fallbackTags.containsKey(this.attributes[i].key)) continue;
            return i;
        }
        return -1;
    }

    public void setHadAlternative(boolean hadAlternative) {
        this.hadAlternative = hadAlternative;
        if (this.context != null && this.context.debug && hadAlternative) {
            this.context = this.context.clone();
            this.context.debug = false;
        }
    }

    public long getLongContext(int attribute) {
        block3: {
            try {
                if (this.hasContext(attribute)) {
                    return Long.parseLong(this.getContext(attribute));
                }
            }
            catch (Exception ex) {
                if (this.hasAlternative()) break block3;
                Debug.echoError("Tag <" + this.toString() + "> has invalid input - expected a number, got '" + this.getContext(attribute) + "'...: " + ex.getMessage());
            }
        }
        return 0L;
    }

    public int getIntContext(int attribute) {
        block3: {
            try {
                if (this.hasContext(attribute)) {
                    return Integer.parseInt(this.getContext(attribute));
                }
            }
            catch (Exception ex) {
                if (this.hasAlternative()) break block3;
                Debug.echoError("Tag <" + this.toString() + "> has invalid input - expected a number, got '" + this.getContext(attribute) + "'...: " + ex.getMessage());
            }
        }
        return 0;
    }

    public double getDoubleContext(int attribute) {
        block3: {
            try {
                if (this.hasContext(attribute)) {
                    return Double.parseDouble(this.getContext(attribute));
                }
            }
            catch (NumberFormatException ex) {
                if (this.hasAlternative()) break block3;
                Debug.echoError("Tag <" + this.toString() + "> has invalid input - expected a decimal number, got '" + this.getContext(attribute) + "'...: " + ex.getMessage());
            }
        }
        return 0.0;
    }

    public void echoError(Throwable ex) {
        if (!this.hasAlternative()) {
            Debug.echoError(ex);
        }
    }

    public void echoError(String message) {
        if (!this.hasAlternative()) {
            Debug.echoError(this.context, message);
        }
    }

    public String getAttribute(int num) {
        if ((num += this.fulfilled - 1) < 0 || num >= this.attributes.length) {
            return "";
        }
        return this.attributes[num].toString();
    }

    public String getAttributeWithoutContext(int num) {
        if ((num += this.fulfilled - 1) < 0 || num >= this.attributes.length) {
            return "";
        }
        return this.attributes[num].key;
    }

    public String filledString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fulfilled; ++i) {
            if (this.contexts[i] != null) {
                sb.append(this.attributes[i].key).append("[").append(this.contexts[i]).append("].");
                continue;
            }
            sb.append(this.attributes[i].toString()).append(".");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public String unfilledString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.fulfilled; i < this.attributes.length; ++i) {
            if (this.contexts[i] != null) {
                sb.append(this.attributes[i].key).append("[").append(this.contexts[i]).append("].");
                continue;
            }
            sb.append(this.attributes[i].toString()).append(".");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.filled != null) {
                sb.append(this.filled[i] == null ? "<Y>" : (this.filled[i] != false ? "<GR>" : "<R>"));
            } else {
                sb.append(i < this.fulfilled ? "<GR>" : (i == this.fulfilled ? "<R>" : "<Y>"));
            }
            sb.append(this.attributes[i].key);
            if (this.contexts[i] != null) {
                sb.append("<LG>[<A>").append(this.contexts[i]).append("<LG>].");
                continue;
            }
            if (this.attributes[i].context != null) {
                sb.append("<LG>[<Y>").append(this.attributes[i].context).append("<LG>].");
                continue;
            }
            sb.append("<LG>.");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    static {
        fallbackTags.put("if_null", new TagManager.TagBaseData("if_null", ObjectTag.class, attribute -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return attribute.getContextObject(1);
        }));
        fallbackTags.put("exists", new TagManager.TagBaseData("if_null", ElementTag.class, attribute -> new ElementTag(false)));
        fallbackTags.put("is_truthy", new TagManager.TagBaseData("if_null", ElementTag.class, attribute -> new ElementTag(false)));
    }

    public static class OverridingDefinitionProvider
    implements DefinitionProvider {
        public DefinitionProvider originalProvider;
        public MapTag altDefs = new MapTag();

        public OverridingDefinitionProvider(DefinitionProvider original) {
            this.originalProvider = original;
        }

        @Override
        public void addDefinition(String definition, String value) {
            this.originalProvider.addDefinition(definition, value);
        }

        @Override
        public void addDefinition(String definition, ObjectTag value) {
            this.originalProvider.addDefinition(definition, value);
        }

        @Override
        public MapTag getAllDefinitions() {
            return this.originalProvider.getAllDefinitions();
        }

        @Override
        public ObjectTag getDefinitionObject(String definition) {
            ObjectTag result = this.altDefs.getDeepObject(CoreUtilities.toLowerCase(definition));
            if (result != null) {
                return result;
            }
            return this.originalProvider.getDefinitionObject(definition);
        }

        @Override
        public String getDefinition(String definition) {
            ObjectTag result = this.altDefs.getDeepObject(CoreUtilities.toLowerCase(definition));
            if (result != null) {
                return result.toString();
            }
            return this.originalProvider.getDefinition(definition);
        }

        @Override
        public boolean hasDefinition(String definition) {
            ObjectTag result = this.altDefs.getDeepObject(CoreUtilities.toLowerCase(definition));
            if (result != null) {
                return true;
            }
            return this.originalProvider.hasDefinition(definition);
        }

        @Override
        public void removeDefinition(String definition) {
            this.originalProvider.removeDefinition(definition);
        }
    }

    public static class AttributeComponent {
        public final String rawKey;
        public final String key;
        public final String context;
        public ParseableTag contextParsed;
        public ObjectTagProcessor.TagData<?, ?> data;

        public AttributeComponent(String inp) {
            if (inp.endsWith("]") && CoreUtilities.contains(inp, '[')) {
                int ind = inp.indexOf(91);
                this.rawKey = inp.substring(0, ind);
                this.context = inp.substring(ind + 1, inp.length() - 1);
            } else {
                this.rawKey = inp;
                this.context = null;
            }
            this.key = CoreUtilities.toLowerCase(this.rawKey);
        }

        public String toString() {
            if (this.context != null) {
                return this.key + "[" + this.context + "]";
            }
            return this.key;
        }
    }
}

