/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import net.citizensnpcs.trait.LookClose;

public class LookcloseCommand
extends AbstractCommand {
    public LookcloseCommand() {
        this.setName("lookclose");
        this.setSyntax("lookclose (<npc>) (state:<true/false>) (range:<#>) (realistic)");
        this.setRequiredArguments(0, 4);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (arg.matches("realistic", "realistically")) {
                scriptEntry.addObject("realistic", new ElementTag(true));
                continue;
            }
            if (arg.matchesInteger()) {
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (arg.matchesBoolean()) {
                scriptEntry.addObject("toggle", arg.asElement());
                continue;
            }
            if (arg.matchesArgumentType(NPCTag.class)) {
                ((BukkitScriptEntryData)scriptEntry.entryData).setNPC(arg.asType(NPCTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (Utilities.getEntryNPC(scriptEntry) == null) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), Utilities.getEntryNPC(scriptEntry).debug() + ArgumentHelper.debugObj("realistic", scriptEntry.getObject("realistic")) + ArgumentHelper.debugObj("range", scriptEntry.getObject("range")) + ArgumentHelper.debugObj("toggle", scriptEntry.getObject("toggle")));
        }
        LookClose trait = (LookClose)Utilities.getEntryNPC(scriptEntry).getCitizen().getOrAddTrait(LookClose.class);
        if (scriptEntry.hasObject("toggle")) {
            trait.lookClose(scriptEntry.getElement("toggle").asBoolean());
        }
        if (scriptEntry.hasObject("realistic")) {
            trait.setRealisticLooking(true);
        } else {
            trait.setRealisticLooking(false);
        }
        if (scriptEntry.hasObject("range")) {
            trait.setRange(scriptEntry.getElement("range").asInt());
        }
    }
}

