/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.plugin.Plugin;

public class VehicleCollidesEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VehicleCollidesEntityScriptEvent instance;
    public dEntity vehicle;
    public dEntity entity;
    private Boolean pickup_cancel;
    public VehicleEntityCollisionEvent event;

    public VehicleCollidesEntityScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains("collides with");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String s = path.event;
        String lower = path.eventLower;
        if (!this.tryEntity(this.vehicle, CoreUtilities.getXthArg(0, lower))) {
            return false;
        }
        if (!this.tryEntity(this.entity, CoreUtilities.getXthArg(3, lower))) {
            return false;
        }
        return this.runInCheck(path, this.vehicle.getLocation());
    }

    @Override
    public String getName() {
        return "VehicleCollidesEntity";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        VehicleEntityCollisionEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        aH.Argument arg = aH.Argument.valueOf(determination);
        if (arg.matchesPrefix("pickup")) {
            this.pickup_cancel = !arg.asElement().asBoolean();
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null, this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle;
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("pickup")) {
            return new Element(this.pickup_cancel == false);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleCollidesEntity(VehicleEntityCollisionEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.vehicle = new dEntity((Entity)event.getVehicle());
        this.pickup_cancel = event.isPickupCancelled();
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setPickupCancelled(this.pickup_cancel.booleanValue());
    }
}

