/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;

public class EntityItem
implements Property {
    public static final String[] handledTags = new String[]{"item"};
    public static final String[] handledMechs = new String[]{"item"};
    dEntity item;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity && (((dEntity)entity).getBukkitEntityType() == EntityType.DROPPED_ITEM || ((dEntity)entity).getBukkitEntityType() == EntityType.ENDERMAN);
    }

    public static EntityItem getFrom(dObject entity) {
        if (!EntityItem.describes(entity)) {
            return null;
        }
        return new EntityItem((dEntity)entity);
    }

    private EntityItem(dEntity entity) {
        this.item = entity;
    }

    public dItem getItem() {
        if (this.item.getBukkitEntity() instanceof Item) {
            return new dItem(((Item)this.item.getBukkitEntity()).getItemStack());
        }
        return new dItem(((Enderman)this.item.getBukkitEntity()).getCarriedMaterial());
    }

    @Override
    public String getPropertyString() {
        dItem item = this.getItem();
        if (item.getItemStack().getType() != Material.AIR) {
            return item.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "item";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("item")) {
            return this.getItem().getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("item") && mechanism.requireObject(dItem.class)) {
            if (this.item.getBukkitEntity() instanceof Item) {
                ((Item)this.item.getBukkitEntity()).setItemStack(mechanism.getValue().asType(dItem.class).getItemStack());
            } else {
                NMSHandler.getInstance().getEntityHelper().setCarriedItem((Enderman)this.item.getBukkitEntity(), mechanism.getValue().asType(dItem.class).getItemStack());
            }
        }
    }
}

