/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.core.FlagCommand;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ExCommandHandler
implements CommandExecutor,
TabCompleter {
    public void enableFor(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String alias, String[] args) {
        if (cmd.getName().equalsIgnoreCase("ex")) {
            boolean quiet;
            ArrayList<Object> entries = new ArrayList<Object>();
            String entry = String.join((CharSequence)" ", args);
            boolean bl = quiet = !Settings.showExDebug();
            if (entry.length() > 3 && entry.startsWith("-q ")) {
                quiet = !quiet;
                entry = entry.substring("-q ".length());
            }
            if (entry.length() < 2) {
                sender.sendMessage("/ex (-q) <denizen script command> (arguments)");
                return true;
            }
            if (Settings.showExHelp()) {
                if (Debug.showDebug) {
                    if (quiet) {
                        sender.sendMessage(ChatColor.YELLOW + "Executing Denizen script command... check the console for full debug output!");
                    } else {
                        sender.sendMessage(ChatColor.YELLOW + "Executing Denizen script command...");
                    }
                } else {
                    sender.sendMessage(ChatColor.YELLOW + "Executing Denizen script command... to see debug, use /denizen debug");
                }
            }
            entries.add(entry);
            InstantQueue queue = new InstantQueue("EXCOMMAND");
            NPCTag npc = null;
            if (Depends.citizens != null && Depends.citizens.getNPCSelector().getSelected(sender) != null) {
                npc = new NPCTag(Depends.citizens.getNPCSelector().getSelected(sender));
            }
            List<ScriptEntry> scriptEntries = ScriptBuilder.buildScriptEntries(entries, null, new BukkitScriptEntryData(sender instanceof Player ? new PlayerTag((Player)sender) : null, npc));
            queue.addEntries(scriptEntries);
            if (!quiet && sender instanceof Player) {
                Player player = (Player)sender;
                queue.debugOutput = s -> player.spigot().sendMessage(FormattedTextHelper.parse(s, net.md_5.bungee.api.ChatColor.WHITE));
            }
            queue.start();
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String cmdName, String[] rawArgs) {
        String[] args;
        block32: {
            boolean isCommandArg;
            boolean isNewArg;
            if (!cmdName.equalsIgnoreCase("ex") && !cmdName.equalsIgnoreCase("exs") || !sender.hasPermission("denizen.ex")) {
                return null;
            }
            String entry = String.join((CharSequence)" ", rawArgs);
            if (entry.length() > 3 && entry.startsWith("-q ")) {
                entry = entry.substring("-q ".length());
            }
            args = ArgumentHelper.buildArgs(entry);
            boolean bl = isNewArg = rawArgs.length == 0 || rawArgs[rawArgs.length - 1].isEmpty();
            boolean bl2 = args.length == 0 || args.length == 1 && !isNewArg || args[args.length - (isNewArg ? 1 : 2)].equals("-") ? true : (isCommandArg = false);
            if (isCommandArg) {
                if (isNewArg || args.length == 0) {
                    return new ArrayList<String>(DenizenCore.commandRegistry.instances.keySet());
                }
                ArrayList<String> output = new ArrayList<String>();
                String startOfName = CoreUtilities.toLowerCase(args[args.length - 1]);
                for (String command : DenizenCore.commandRegistry.instances.keySet()) {
                    if (!command.startsWith(startOfName)) continue;
                    output.add(command);
                }
                return output;
            }
            if (isNewArg) break block32;
            String lastArg = rawArgs[rawArgs.length - 1];
            int argStart = 0;
            for (int i = 0; i < lastArg.length(); ++i) {
                if (lastArg.charAt(i) == '\"' || lastArg.charAt(i) == '\'') {
                    char quote = lastArg.charAt(i++);
                    while (i < lastArg.length() && lastArg.charAt(i) != quote) {
                        ++i;
                    }
                    continue;
                }
                if (lastArg.charAt(i) != ' ') continue;
                argStart = i + 1;
            }
            String arg = lastArg.substring(argStart);
            if (!CoreUtilities.contains(arg, '<')) break block32;
            int tagBits = 0;
            int relevantTagStart = -1;
            for (int i = arg.length() - 1; i >= 0; --i) {
                if (arg.charAt(i) == '>') {
                    ++tagBits;
                    continue;
                }
                if (arg.charAt(i) != '<') continue;
                if (tagBits == 0) {
                    relevantTagStart = i + 1;
                    break;
                }
                --tagBits;
            }
            if (relevantTagStart == -1) break block32;
            String fullTag = CoreUtilities.toLowerCase(arg.substring(relevantTagStart));
            int components = 0;
            int subTags = 0;
            int squareBrackets = 0;
            int lastDot = 0;
            int bracketStart = -1;
            Collection<Class<? extends ObjectTag>> typesApplicable = null;
            for (int i = 0; i < fullTag.length(); ++i) {
                Class type;
                block34: {
                    String part;
                    block33: {
                        char c = fullTag.charAt(i);
                        if (c == '<') {
                            ++subTags;
                            continue;
                        }
                        if (c == '>') {
                            --subTags;
                            continue;
                        }
                        if (c == '[' && subTags == 0) {
                            ++squareBrackets;
                            bracketStart = i;
                            continue;
                        }
                        if (c == ']' && subTags == 0) {
                            --squareBrackets;
                            continue;
                        }
                        if (c != '.' || subTags != 0 || squareBrackets != 0) continue;
                        type = null;
                        part = fullTag.substring(lastDot, bracketStart == -1 ? i : bracketStart);
                        if (components != 0) break block33;
                        TagManager.TagBaseData tagBaseData = TagManager.baseTags.get(part);
                        if (tagBaseData == null) break block34;
                        type = tagBaseData.returnType;
                        break block34;
                    }
                    if (typesApplicable != null) {
                        for (Class clazz : typesApplicable) {
                            ObjectTagProcessor.TagData<? extends ObjectTag, ? extends ObjectTag> data;
                            ObjectFetcher.ObjectType<? extends ObjectTag> typeData = ObjectFetcher.objectsByClass.get(clazz);
                            if (typeData == null || typeData.tagProcessor == null || (data = typeData.tagProcessor.registeredObjectTags.get(part)) == null || data.returnType == null) continue;
                            type = data.returnType;
                            break;
                        }
                    }
                }
                typesApplicable = type != null ? ObjectFetcher.getAllApplicableSubTypesFor(type) : ObjectFetcher.objectsByClass.keySet();
                ++components;
                lastDot = i + 1;
                bracketStart = -1;
            }
            String beforeDot = arg.substring(0, relevantTagStart) + fullTag.substring(0, lastDot);
            if (components == 0 && !CoreUtilities.contains(fullTag, '[')) {
                ArrayList<String> output = new ArrayList<String>();
                for (String tagBase : TagManager.baseTags.keySet()) {
                    if (!tagBase.startsWith(fullTag)) continue;
                    output.add(beforeDot + tagBase);
                }
                return output;
            }
            String subComponent = fullTag.substring(lastDot);
            if (lastDot > 0 && !CoreUtilities.contains(subComponent, '[')) {
                ArrayList<String> output = new ArrayList<String>();
                for (Class clazz : typesApplicable) {
                    ObjectFetcher.ObjectType<? extends ObjectTag> objectType = ObjectFetcher.objectsByClass.get(clazz);
                    if (objectType == null || objectType.tagProcessor == null) continue;
                    for (String tag : objectType.tagProcessor.registeredObjectTags.keySet()) {
                        if (!tag.startsWith(subComponent)) continue;
                        output.add(beforeDot + tag);
                    }
                }
                return output;
            }
        }
        AbstractCommand dcmd = DenizenCore.commandRegistry.get(args[0]);
        for (int i = args.length - 2; i >= 0; --i) {
            if (!args[i].equals("-")) continue;
            dcmd = DenizenCore.commandRegistry.get(args[i + 1]);
        }
        if (dcmd == null) {
            return null;
        }
        String lowArg = CoreUtilities.toLowerCase(rawArgs[rawArgs.length - 1]);
        ArrayList<String> output = new ArrayList<String>();
        for (String flat : dcmd.flatArgs) {
            if (!flat.startsWith(lowArg)) continue;
            output.add(flat);
        }
        for (String prefix : dcmd.prefixes) {
            if (!prefix.startsWith(lowArg)) continue;
            output.add(prefix + ":");
        }
        Consumer<String> addOne = s -> {
            if (CoreUtilities.toLowerCase(s).startsWith(lowArg)) {
                output.add((String)s);
            }
        };
        dcmd.addCustomTabCompletions(lowArg, addOne);
        if (dcmd instanceof FlagCommand) {
            if (sender instanceof Player) {
                for (String flagName : new PlayerTag((Player)sender).getFlagTracker().listAllFlags()) {
                    if (flagName.startsWith("__")) continue;
                    addOne.accept(flagName);
                }
            }
            if (Depends.citizens != null && Depends.citizens.getNPCSelector().getSelected(sender) != null) {
                for (String flagName : new NPCTag(Depends.citizens.getNPCSelector().getSelected(sender)).getFlagTracker().listAllFlags()) {
                    if (flagName.startsWith("__")) continue;
                    addOne.accept(flagName);
                }
            }
        }
        return output;
    }
}

