/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DisguiseCommand
extends AbstractCommand {
    public static HashMap<UUID, HashMap<UUID, TrackedDisguise>> disguises = new HashMap();

    public DisguiseCommand() {
        this.setName("disguise");
        this.setSyntax("disguise [<entity>] [cancel/as:<type>] (global/players:<player>|...)");
        this.setRequiredArguments(2, 4);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        if (arg.startsWith("as:")) {
            for (EntityType entity : EntityType.values()) {
                addOne.accept("as:" + entity.name());
            }
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("to", "players")) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("global") && arg.matches("global")) {
                scriptEntry.addObject("global", new ElementTag(true));
                continue;
            }
            if (arg.matchesPrefix("as") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("as", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entity") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("entity", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel")) {
                scriptEntry.addObject("cancel", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("players") && Utilities.entryHasPlayer(scriptEntry)) {
            if (scriptEntry.hasObject("global")) {
                scriptEntry.defaultObject("players", new ArrayList());
            } else {
                scriptEntry.defaultObject("players", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry)));
            }
        }
        if (!scriptEntry.hasObject("as") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Must specify a valid type to disguise as!");
        }
        if (!scriptEntry.hasObject("players") && !scriptEntry.hasObject("global")) {
            throw new InvalidArgumentsException("Must have a valid player attached, or 'global' set!");
        }
        if (!scriptEntry.hasObject("entity")) {
            throw new InvalidArgumentsException("Must specify a valid entity!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        NetworkInterceptHelper.enable();
        EntityTag entity = (EntityTag)scriptEntry.getObjectTag("entity");
        EntityTag as = (EntityTag)scriptEntry.getObjectTag("as");
        ElementTag cancel = scriptEntry.getElement("cancel");
        ElementTag global = scriptEntry.getElement("global");
        List players = (List)scriptEntry.getObject("players");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), entity.debug() + (cancel != null ? cancel.debug() : as.debug()) + (global != null ? global.debug() : "") + ArgumentHelper.debugList("players", players));
        }
        boolean isGlobal = global != null && global.asBoolean();
        HashMap playerMap = disguises.get(entity.getUUID());
        if (playerMap != null) {
            if (isGlobal) {
                for (Map.Entry entry : playerMap.entrySet()) {
                    if (entry.getKey() == null) {
                        if (((TrackedDisguise)entry.getValue()).toOthers != null) {
                            FakeEntity.idsToEntities.remove(((TrackedDisguise)entry.getValue()).toOthers.overrideUUID);
                        }
                        for (Player player : entity.getWorld().getPlayers()) {
                            if (EntityTag.isNPC((Entity)player)) continue;
                            ((TrackedDisguise)entry.getValue()).removeFor(new PlayerTag(player));
                        }
                    } else {
                        PlayerTag player = new PlayerTag((UUID)entry.getKey());
                        ((TrackedDisguise)entry.getValue()).removeFor(player);
                    }
                    ((TrackedDisguise)entry.getValue()).isActive = false;
                }
                disguises.remove(entity.getUUID());
            } else {
                for (PlayerTag playerTag : players) {
                    TrackedDisguise disguise = playerMap.remove(playerTag.getUUID());
                    if (disguise == null) continue;
                    disguise.isActive = false;
                    disguise.removeFor(playerTag);
                    if (disguise.toOthers != null) {
                        FakeEntity.idsToEntities.remove(disguise.toOthers.overrideUUID);
                    }
                    if (!playerMap.isEmpty()) continue;
                    disguises.remove(entity.getUUID());
                }
            }
        }
        if (cancel == null || !cancel.asBoolean()) {
            TrackedDisguise disguise = new TrackedDisguise(entity, as);
            disguise.as.entity = NMSHandler.getPlayerHelper().sendEntitySpawn(new ArrayList<PlayerTag>(), (DenizenEntityType)as.getEntityType(), (LocationTag)entity.getLocation(), as.getWaitingMechanisms(), (int)-1, null, (boolean)false).entity.getBukkitEntity();
            if (isGlobal) {
                playerMap = disguises.computeIfAbsent(entity.getUUID(), k -> new HashMap());
                playerMap.put(null, disguise);
                disguise.isActive = true;
                ArrayList<PlayerTag> arrayList = players == null ? new ArrayList<PlayerTag>() : new ArrayList(players);
                for (Player player : entity.getWorld().getPlayers()) {
                    if (EntityTag.isNPC((Entity)player) || arrayList.contains(new PlayerTag(player)) || player.getUniqueId().equals(entity.getUUID())) continue;
                    arrayList.add(new PlayerTag(player));
                }
                disguise.sendTo(arrayList);
            } else {
                if (players != null) {
                    for (PlayerTag player : players) {
                        playerMap = disguises.computeIfAbsent(entity.getUUID(), k -> new HashMap());
                        playerMap.put(player.getUUID(), disguise);
                        disguise.isActive = true;
                    }
                }
                disguise.sendTo(players);
            }
        }
    }

    public static class TrackedDisguise
    implements Listener {
        public EntityTag entity;
        public EntityTag as;
        public FakeEntity fakeToSelf;
        public FakeEntity toOthers;
        public boolean shouldFake;
        public boolean isActive;

        public TrackedDisguise(EntityTag entity, EntityTag as) {
            this.entity = entity;
            this.as = as;
        }

        public void removeFor(PlayerTag player) {
            if (player.getUUID().equals(this.entity.getUUID())) {
                if (this.fakeToSelf != null) {
                    this.stopFake(player);
                }
                if (this.shouldFake) {
                    HandlerList.unregisterAll((Listener)this);
                    this.shouldFake = false;
                }
            } else if (player.isOnline()) {
                NMSHandler.getPlayerHelper().deTrackEntity(player.getPlayerEntity(), this.entity.getBukkitEntity());
            }
        }

        public void moveFakeNow(Location position) {
            NMSHandler.getEntityHelper().snapPositionTo(this.fakeToSelf.entity.getBukkitEntity(), position.toVector());
            NMSHandler.getEntityHelper().look(this.fakeToSelf.entity.getBukkitEntity(), position.getYaw(), position.getPitch());
        }

        public void startFake(final PlayerTag player) {
            if (this.fakeToSelf != null) {
                this.stopFake(player);
            }
            if (!this.shouldFake) {
                this.shouldFake = true;
                Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
            }
            if (!player.isOnline()) {
                return;
            }
            this.fakeToSelf = FakeEntity.showFakeEntityTo(Collections.singletonList(player), this.as, player.getLocation(), null);
            NMSHandler.getPacketHelper().generateNoCollideTeam(player.getPlayerEntity(), this.fakeToSelf.entity.getUUID());
            NMSHandler.getPacketHelper().sendEntityMetadataFlagsUpdate(player.getPlayerEntity(), (Entity)player.getPlayerEntity());
            new BukkitRunnable(){

                public void run() {
                    if (fakeToSelf == null || !fakeToSelf.entity.isFakeValid || !player.isOnline()) {
                        this.stopFake(player);
                        this.cancel();
                        return;
                    }
                    this.moveFakeNow(player.getLocation());
                }
            }.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 1L);
        }

        public void stopFake(final PlayerTag player) {
            if (this.fakeToSelf == null) {
                return;
            }
            if (player.isOnline()) {
                NMSHandler.getPacketHelper().removeNoCollideTeam(player.getPlayerEntity(), this.fakeToSelf.entity.getUUID());
                new BukkitRunnable(){

                    public void run() {
                        if (player.isOnline()) {
                            NMSHandler.getPacketHelper().sendEntityMetadataFlagsUpdate(player.getPlayerEntity(), (Entity)player.getPlayerEntity());
                        }
                    }
                }.runTaskLater((Plugin)Denizen.getInstance(), 2L);
            }
            this.fakeToSelf.cancelEntity();
            this.fakeToSelf = null;
        }

        public void sendTo(List<PlayerTag> players) {
            PlayerTag remove = null;
            for (PlayerTag player : players) {
                if (player.getUUID().equals(this.entity.getUUID())) {
                    remove = player;
                    this.startFake(player);
                    continue;
                }
                NMSHandler.getPlayerHelper().sendEntityDestroy(player.getPlayerEntity(), this.entity.getBukkitEntity());
            }
            if (remove != null) {
                if (players.size() == 1) {
                    return;
                }
                players.remove(remove);
            }
            if (players.isEmpty()) {
                return;
            }
            if (this.toOthers == null) {
                this.toOthers = NMSHandler.getPlayerHelper().sendEntitySpawn(players, this.as.getEntityType(), this.entity.getLocation(), this.as.getWaitingMechanisms(), this.entity.getBukkitEntity().getEntityId(), this.entity.getUUID(), false);
                this.toOthers.entity.uuid = this.toOthers.overrideUUID = UUID.randomUUID();
                FakeEntity.idsToEntities.put(this.toOthers.overrideUUID, this.toOthers);
            } else {
                for (PlayerTag player : players) {
                    this.toOthers.triggerSpawnPacket.accept(player);
                }
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onJoin(final PlayerJoinEvent event) {
            if (!this.shouldFake || !event.getPlayer().getUniqueId().equals(this.entity.getUUID())) {
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    if (!event.getPlayer().isOnline() || !isActive) {
                        return;
                    }
                    this.startFake(new PlayerTag(event.getPlayer()));
                }
            }.runTaskLater((Plugin)Denizen.getInstance(), 2L);
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onTeleport(final PlayerTeleportEvent event) {
            if (this.fakeToSelf == null || !event.getPlayer().getUniqueId().equals(this.entity.getUUID())) {
                return;
            }
            this.stopFake(new PlayerTag(event.getPlayer()));
            new BukkitRunnable(){

                public void run() {
                    if (!event.getPlayer().isOnline() || !isActive) {
                        return;
                    }
                    this.startFake(new PlayerTag(event.getPlayer()));
                }
            }.runTaskLater((Plugin)Denizen.getInstance(), 2L);
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onMove(PlayerMoveEvent event) {
            if (this.fakeToSelf == null || !event.getPlayer().getUniqueId().equals(this.entity.getUUID())) {
                return;
            }
            if (event.getTo() == null) {
                return;
            }
            this.moveFakeNow(event.getTo());
            if (this.fakeToSelf.triggerUpdatePacket != null) {
                this.fakeToSelf.triggerUpdatePacket.run();
            }
        }
    }
}

