/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class OxygenCommand
extends AbstractCommand {
    public OxygenCommand() {
        this.setName("oxygen");
        this.setSyntax("oxygen [<#>] (type:{remaining}/maximum) (mode:{set}/add/remove)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("type") && arg.matchesPrefix("type", "t") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("mode") && arg.matchesPrefix("mode", "m") && arg.matchesEnum(Mode.values())) {
                scriptEntry.addObject("mode", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("amount") || !arg.matchesInteger()) continue;
            scriptEntry.addObject("amount", arg.asElement());
        }
        if (!Utilities.entryHasPlayer(scriptEntry) || !Utilities.getEntryPlayer(scriptEntry).isValid()) {
            throw new InvalidArgumentsException("Must have player context!");
        }
        if (!scriptEntry.hasObject("amount")) {
            throw new InvalidArgumentsException("Must specify a valid amount!");
        }
        scriptEntry.defaultObject("type", new ElementTag("REMAINING")).defaultObject("mode", new ElementTag("SET"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag type = scriptEntry.getElement("type");
        ElementTag mode = scriptEntry.getElement("mode");
        ElementTag amount = scriptEntry.getElement("amount");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), type.debug() + mode.debug() + amount.debug());
        }
        PlayerTag player = Utilities.getEntryPlayer(scriptEntry);
        block0 : switch (Type.valueOf(type.asString().toUpperCase())) {
            case MAXIMUM: {
                switch (Mode.valueOf(mode.asString().toUpperCase())) {
                    case SET: {
                        player.setMaximumAir(amount.asInt());
                        break;
                    }
                    case ADD: {
                        player.setMaximumAir(player.getMaximumAir() + amount.asInt());
                        break;
                    }
                    case REMOVE: {
                        player.setMaximumAir(player.getMaximumAir() - amount.asInt());
                    }
                }
                break;
            }
            case REMAINING: {
                switch (Mode.valueOf(mode.asString().toUpperCase())) {
                    case SET: {
                        player.setRemainingAir(amount.asInt());
                        break block0;
                    }
                    case ADD: {
                        player.setRemainingAir(player.getRemainingAir() + amount.asInt());
                        break block0;
                    }
                    case REMOVE: {
                        player.setRemainingAir(player.getRemainingAir() - amount.asInt());
                    }
                }
            }
        }
    }

    public static enum Type {
        MAXIMUM,
        REMAINING;

    }

    public static enum Mode {
        SET,
        ADD,
        REMOVE;

    }
}

