/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.flags.MapTagFlagTracker;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class EntityScriptContainer
extends ScriptContainer {
    public static HashSet<String> nonMechanismKeys = new HashSet<String>(Arrays.asList("entity_type", "type", "debug", "custom", "data", "flags", "mechanisms"));

    public EntityScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        EntityScriptHelper.scripts.put(CoreUtilities.toLowerCase(this.getName()), this);
        this.canRunScripts = false;
    }

    public EntityTag getEntityFrom() {
        return this.getEntityFrom(null, null);
    }

    public EntityTag getEntityFrom(PlayerTag player, NPCTag npc) {
        EntityTag entity;
        try {
            ObjectTag obj;
            Set<StringHolder> strings;
            BukkitTagContext context = new BukkitTagContext(player, npc, new ScriptTag(this));
            if (!this.contains("entity_type")) {
                throw new Exception("Missing entity_type argument!");
            }
            String entityType = TagManager.tag(this.getString("entity_type", ""), context);
            entity = EntityTag.valueOf(entityType, context);
            if (this.contains("flags")) {
                YamlConfiguration flagSection = this.getConfigurationSection("flags");
                MapTagFlagTracker tracker = new MapTagFlagTracker();
                for (StringHolder key : flagSection.getKeys(false)) {
                    tracker.setFlag(key.str, CoreUtilities.objectToTagForm(flagSection.get(key.str), context, true, true), null);
                }
                entity.safeAdjust(new Mechanism("flag_map", tracker.map, context));
            }
            if (this.contains("mechanisms")) {
                YamlConfiguration mechSection = this.getConfigurationSection("mechanisms");
                strings = mechSection.getKeys(false);
                for (StringHolder string : strings) {
                    obj = CoreUtilities.objectToTagForm(mechSection.get(string.low), context, true, true);
                    entity.safeAdjust(new Mechanism(string.low, obj, context));
                }
            }
            boolean any = false;
            strings = this.getContents().getKeys(false);
            for (StringHolder string : strings) {
                if (nonMechanismKeys.contains(string.low)) continue;
                any = true;
                obj = CoreUtilities.objectToTagForm(this.getContents().get(string.low), context, true, true);
                entity.safeAdjust(new Mechanism(string.low, obj, context));
            }
            if (any) {
                Deprecations.entityMechanismsFormat.warn(this);
            }
            if (entity == null || entity.isUnique()) {
                return null;
            }
            entity.setEntityScript(this.getName());
        }
        catch (Exception e) {
            Debug.echoError("Woah! An exception has been called with this entity script!");
            Debug.echoError(e);
            entity = null;
        }
        return entity;
    }
}

