/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.EntityType;

public class FakeSpawnCommand
extends AbstractCommand {
    public FakeSpawnCommand() {
        this.setName("fakespawn");
        this.setSyntax("fakespawn [<entity>] [<location>/cancel] (players:<player>|...) (d:<duration>{10s})");
        this.setRequiredArguments(2, 4);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (EntityType entity : EntityType.values()) {
            addOne.accept(entity.name());
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("to", "players")) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (arg.matchesPrefix("d", "duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entity") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("entity", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel")) {
                scriptEntry.addObject("cancel", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("players") && Utilities.entryHasPlayer(scriptEntry)) {
            scriptEntry.defaultObject("players", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry)));
        }
        if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Must specify a valid location!");
        }
        if (!scriptEntry.hasObject("players")) {
            throw new InvalidArgumentsException("Must have a valid, online player attached!");
        }
        if (!scriptEntry.hasObject("entity")) {
            throw new InvalidArgumentsException("Must specify a valid entity!");
        }
        scriptEntry.defaultObject("duration", new DurationTag(10));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        EntityTag entity = (EntityTag)scriptEntry.getObjectTag("entity");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        List players = (List)scriptEntry.getObject("players");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        ElementTag cancel = scriptEntry.getElement("cancel");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), entity.debug() + (cancel != null ? cancel.debug() : location.debug() + duration.debug()) + ArgumentHelper.debugList("players", players));
        }
        if (cancel != null && cancel.asBoolean()) {
            if (entity.isFake) {
                FakeEntity fakeEnt = FakeEntity.idsToEntities.get(entity.getUUID());
                if (fakeEnt != null) {
                    fakeEnt.cancelEntity();
                } else {
                    Debug.echoDebug((Debuggable)scriptEntry, "Entity '" + entity + "' cannot be cancelled: not listed in fake-entity map.");
                }
            }
        } else {
            FakeEntity created = FakeEntity.showFakeEntityTo(players, entity, location, duration);
            scriptEntry.addObject("faked_entity", created.entity);
        }
    }
}

