/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.tags.core.UtilTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class AdjustCommand
extends AbstractCommand {
    public static HashMap<String, Consumer<Mechanism>> specialAdjustables = new HashMap();

    public AdjustCommand() {
        this.setName("adjust");
        this.setSyntax("adjust [<ObjectTag>/def:<name>|...] [<mechanism>](:<value>)");
        this.setRequiredArguments(2, 2);
        this.isProcedural = true;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (String mech : PropertyParser.allMechanismsEver) {
            addOne.accept(mech);
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("object")) {
                if (arg.object instanceof ListTag) {
                    scriptEntry.addObject("object", arg.object);
                    continue;
                }
                if (arg.object instanceof ElementTag) {
                    scriptEntry.addObject("object", ListTag.valueOf(arg.getRawValue(), scriptEntry.getContext()));
                    continue;
                }
                scriptEntry.addObject("object", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("mechanism") && !scriptEntry.hasObject("mechanism_map")) {
                if (arg.getRawValue().startsWith("map@")) {
                    scriptEntry.addObject("mechanism_map", arg.asType(MapTag.class));
                    continue;
                }
                if (arg.hasPrefix()) {
                    scriptEntry.addObject("mechanism", new ElementTag(arg.getPrefix().getValue()));
                    scriptEntry.addObject("mechanism_value", arg.object);
                    continue;
                }
                scriptEntry.addObject("mechanism", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("object")) {
            throw new InvalidArgumentsException("You must specify an object!");
        }
        if (!scriptEntry.hasObject("mechanism") && !scriptEntry.hasObject("mechanism_map")) {
            throw new InvalidArgumentsException("You must specify a mechanism!");
        }
    }

    public ObjectTag adjust(ObjectTag object, String mechanismName, ObjectTag value, ScriptEntry entry) {
        Mechanism mechanism = new Mechanism(mechanismName, value, entry.entryData.getTagContext());
        return this.adjust(object, mechanism, entry);
    }

    public ObjectTag adjust(ObjectTag object, Mechanism mechanism, ScriptEntry entry) {
        if (object == null) {
            Debug.echoError("Cannot adjust null object.");
            return null;
        }
        if (object instanceof ElementTag) {
            String objectString = object.toString();
            String lowerObjectString = CoreUtilities.toLowerCase(objectString);
            Consumer<Mechanism> specialAdjustable = specialAdjustables.get(lowerObjectString);
            if (specialAdjustable != null) {
                specialAdjustable.accept(mechanism);
                return object;
            }
            if (lowerObjectString.startsWith("def:")) {
                String defName = lowerObjectString.substring("def:".length());
                ObjectTag def = entry.getResidingQueue().getDefinitionObject(defName);
                if (def == null) {
                    Debug.echoError("Invalid definition name '" + defName + "', cannot adjust");
                    return object;
                }
                def = this.adjust(def, mechanism, entry);
                entry.getResidingQueue().addDefinition(defName, def);
                return def;
            }
            object = ObjectFetcher.pickObjectFor(objectString, entry.context);
            if (object instanceof ElementTag) {
                FlaggableObject altObject = DenizenCore.getImplementation().simpleWordToFlaggable(objectString, entry);
                if (altObject != null && !(altObject instanceof ElementTag)) {
                    return altObject;
                }
                Debug.echoError("Unable to determine what object to adjust (missing object notation?), for: " + objectString);
                return object;
            }
        }
        if (object instanceof ListTag) {
            ListTag subList = (ListTag)object;
            ListTag result = new ListTag();
            for (ObjectTag listObject : subList.objectForms) {
                listObject = this.adjust(listObject, mechanism, entry);
                result.addObject(listObject);
            }
            return result;
        }
        if (!object.isUnique()) {
            object = ObjectFetcher.pickObjectFor(object.identify(), mechanism.context);
        }
        if (!(object instanceof Adjustable)) {
            Debug.echoError("'" + object + "' is not an adjustable object type.");
            return object;
        }
        if (entry.getResidingQueue().procedural && object.isUnique()) {
            Debug.echoError("Cannot adjust a unique object within a procedural queue.");
            return null;
        }
        ((Adjustable)object).safeAdjust(mechanism);
        return object;
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag mechanism = scriptEntry.getElement("mechanism");
        ObjectTag value = (ObjectTag)scriptEntry.getObjectTag("mechanism_value");
        ListTag objects = (ListTag)scriptEntry.getObjectTag("object");
        MapTag mechanismMap = (MapTag)scriptEntry.getObjectTag("mechanism_map");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), objects, value, mechanism, mechanismMap);
        }
        ListTag result = new ListTag();
        for (ObjectTag object : objects.objectForms) {
            if (mechanismMap != null) {
                for (Map.Entry<StringHolder, ObjectTag> entry : mechanismMap.map.entrySet()) {
                    object = this.adjust(object, entry.getKey().str, entry.getValue(), scriptEntry);
                }
            } else {
                object = this.adjust(object, mechanism.asString(), value, scriptEntry);
            }
            if (objects.size() == 1) {
                scriptEntry.addObject("result", object);
            }
            result.addObject(object);
        }
        scriptEntry.addObject("result_list", result);
    }

    static {
        specialAdjustables.put("system", UtilTagBase::adjustSystem);
    }
}

