/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags;

import com.denizenscript.denizencore.exceptions.TagProcessingException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;

public class ReplaceableTagEvent {
    private final TagContext context;
    private boolean wasReplaced = false;
    private String replaced;
    private String value_tagged = null;
    private Attribute core_attributes = null;
    public String raw_tag;
    public ObjectTag replaced_obj = null;
    public ReferenceData mainRef = null;
    public static HashMap<String, ReferenceData> refs = new HashMap();
    public TagManager.TagBaseData alternateBase;

    public ObjectTag getReplacedObj() {
        if (this.replaced_obj == null) {
            if (this.replaced == null) {
                return null;
            }
            this.replaced_obj = new ElementTag(this.replaced);
        }
        return this.replaced_obj;
    }

    public ReplaceableTagEvent(ReferenceData ref, String tag, TagContext context) {
        this.context = context;
        this.replaced = tag;
        if (ref != null) {
            this.mainRef = ref;
            this.core_attributes = new Attribute(ref.attribs, context.entry, context, ref.skippable);
            this.raw_tag = ref.rawTag;
        }
    }

    public ReplaceableTagEvent(String tag, TagContext context) throws TagProcessingException {
        this(refs.get(tag), tag, context);
        int valueLoc;
        if (this.mainRef != null) {
            return;
        }
        String otag = tag;
        this.mainRef = new ReferenceData();
        int alternativeLoc = ReplaceableTagEvent.locateAlternative(tag);
        if (alternativeLoc >= 0) {
            this.mainRef.alternative = tag.substring(alternativeLoc + 2).trim();
            tag = tag.substring(0, alternativeLoc);
        }
        if ((valueLoc = ReplaceableTagEvent.locateValue(tag)) > 0) {
            this.mainRef.value = tag.substring(valueLoc + 1);
            tag = tag.substring(0, valueLoc);
        }
        this.raw_tag = tag.trim();
        this.core_attributes = new Attribute(this.raw_tag, context.entry, context);
        this.core_attributes.setHadAlternative(this.hasAlternative());
        this.mainRef.attribs = new Attribute(this.core_attributes, null, null, 0);
        this.mainRef.rawTag = this.raw_tag;
        String startValue = this.getName();
        this.mainRef.tagBase = TagManager.baseTags.get(startValue);
        if (this.mainRef.tagBase == null && !this.hasAlternative()) {
            Debug.echoError(context.entry, "(Initial detection) No tag-base handler for '" + startValue + "'.");
        }
        refs.put(otag, this.mainRef);
    }

    private static int locateValue(String tag) {
        int bracks = 0;
        int bracks2 = 0;
        for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            if (c == '<') {
                ++bracks;
                continue;
            }
            if (c == '>') {
                --bracks;
                continue;
            }
            if (bracks == 0 && c == '[') {
                ++bracks2;
                continue;
            }
            if (bracks == 0 && c == ']') {
                --bracks2;
                continue;
            }
            if (c != ':' || bracks != 0 || bracks2 != 0) continue;
            return i;
        }
        return -1;
    }

    private static int locateAlternative(String tag) {
        int bracks = 0;
        int bracks2 = 0;
        boolean previousWasTarget = false;
        for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            if (c == '<') {
                ++bracks;
                continue;
            }
            if (c == '>') {
                --bracks;
                continue;
            }
            if (bracks == 0 && c == '[') {
                ++bracks2;
                continue;
            }
            if (bracks == 0 && c == ']') {
                --bracks2;
                continue;
            }
            if (c == '|' && bracks == 0 && bracks2 == 0) {
                if (previousWasTarget) {
                    return i - 1;
                }
                previousWasTarget = true;
                continue;
            }
            previousWasTarget = false;
        }
        return -1;
    }

    public boolean matches(String tagName) {
        return this.getName().equals(tagName);
    }

    public boolean matches(String ... tagNames) {
        String name = this.getName();
        for (String string : tagNames) {
            if (!name.equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.core_attributes.getAttributeWithoutContext(1);
    }

    @Deprecated
    public String getValue() {
        if (this.value_tagged == null) {
            this.value_tagged = TagManager.tag(this.mainRef.value, this.context);
        }
        return this.value_tagged;
    }

    @Deprecated
    public boolean hasValue() {
        return this.mainRef.value != null;
    }

    public ObjectTag getAlternative() {
        int index = this.core_attributes.getFallbackTagIndex();
        if (index != -1) {
            if (this.core_attributes.filled != null) {
                this.core_attributes.filled[this.core_attributes.fulfilled] = 2;
            }
            this.core_attributes.fulfilled = index;
            this.alternateBase = Attribute.fallbackTags.get(this.core_attributes.getAttributeWithoutContext(1));
            return TagManager.readSingleTagObjectNoDebug(this.context, this);
        }
        if (this.mainRef.alternative != null) {
            return TagManager.tagObject(this.mainRef.alternative, this.context);
        }
        return null;
    }

    public boolean hasAlternative() {
        if (this.mainRef.alternative != null) {
            return true;
        }
        return this.core_attributes.hasAlternative();
    }

    public TagContext getContext() {
        return this.context;
    }

    public String getReplaced() {
        if (this.replaced == null && this.replaced_obj != null) {
            this.replaced = this.replaced_obj.toString();
        }
        return this.replaced;
    }

    public ScriptTag getScript() {
        return this.context.script;
    }

    public boolean replaced() {
        return this.wasReplaced && (this.replaced != null || this.replaced_obj != null);
    }

    public void setReplacedObject(ObjectTag obj) {
        this.replaced_obj = obj;
        this.replaced = null;
        this.wasReplaced = obj != null;
    }

    public void setReplaced(String string) {
        if (Debug.verbose) {
            try {
                throw new RuntimeException("Trace");
            }
            catch (Exception ex) {
                Debug.echoError(ex);
                Debug.log("Tag " + this.raw_tag + " updating to value: " + string);
            }
        }
        this.replaced = string;
        this.replaced_obj = null;
        this.wasReplaced = string != null;
    }

    public ScriptEntry getScriptEntry() {
        return this.context.entry;
    }

    public Attribute getAttributes() {
        return this.core_attributes;
    }

    public String toString() {
        return this.core_attributes.toString() + (this.hasValue() ? ":" + this.mainRef.value : "") + (this.mainRef.alternative != null ? "||" + this.mainRef.alternative : "");
    }

    public static class ReferenceData {
        public Attribute attribs = null;
        public String alternative = null;
        public String rawTag = null;
        public String value = null;
        public TagManager.TagBaseData tagBase = null;
        public TagRunnable.BaseInterface<? extends ObjectTag> compiledStart;
        public boolean noGenerate = false;
        public int skippable = 0;
        public ObjectTag rawObject = null;
    }
}

